/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.act;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditorFactory;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;

public abstract class ParticipationEditor<T extends Entity>
extends AbstractIMObjectEditor {
    private final IMObjectReferenceEditor<T> editor;

    public ParticipationEditor(Participation participation, Act parent, LayoutContext context) {
        super((IMObject)participation, (IMObject)parent, context);
        if (parent == null) {
            throw new IllegalArgumentException("Argument 'parent' is null");
        }
        Property entity = this.getEntityProperty();
        this.editor = this.createEntityEditor(entity);
        this.addEditor(this.editor);
        Property act = this.getProperty("act");
        if (act.getValue() == null) {
            act.setValue(parent.getObjectReference());
        }
    }

    public Participation getParticipation() {
        return (Participation)this.getObject();
    }

    public IMObjectReferenceEditor<T> getEditor() {
        return this.editor;
    }

    public Reference getEntityRef() {
        return this.editor.getProperty().getReference();
    }

    public boolean setEntityRef(Reference reference) {
        return this.editor.getProperty().setValue(reference);
    }

    public T getEntity() {
        return (T)((Entity)this.getObject(this.getEntityRef()));
    }

    public boolean setEntity(T entity) {
        return this.editor.setObject(entity);
    }

    public boolean isNull() {
        return this.editor.isNull();
    }

    @Override
    protected void doDelete() {
        if (this.getParent() != null) {
            throw new IllegalStateException("Parent is not set");
        }
    }

    protected Property getEntityProperty() {
        return this.getProperty("entity");
    }

    protected IMObjectReferenceEditor<T> createEntityEditor(Property property) {
        return IMObjectReferenceEditorFactory.create(property, this.getObject(), this.getLayoutContext());
    }

    protected IMObjectReferenceEditor<T> getEntityEditor() {
        return this.editor;
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        IMObjectLayoutStrategy strategy = super.createLayoutStrategy();
        strategy.addComponent(new ComponentState(this.editor));
        return strategy;
    }

    @Override
    protected boolean disposeOnChangeLayout(Editor editor) {
        return editor != this.editor;
    }
}

