/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.act;

import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openvpms.archetype.rules.act.ActCalculator;
import org.openvpms.archetype.rules.act.ActStatusHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.act.ActHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinancialActEditor
extends ActEditor {
    private static final Logger log = LoggerFactory.getLogger(FinancialActEditor.class);

    protected FinancialActEditor(FinancialAct act, IMObject parent, LayoutContext context) {
        super((Act)act, parent, context);
    }

    public FinancialAct getObject() {
        return (FinancialAct)super.getObject();
    }

    public void calculateTax() {
        Property taxAmount = this.getProperty("tax");
        if (taxAmount != null) {
            List<Act> acts = this.getItems().getActs();
            BigDecimal tax = ActHelper.sum((Act)this.getObject(), acts, "tax");
            taxAmount.setValue(tax);
        }
    }

    protected void initialise() {
        FinancialAct act = this.getObject();
        if (!this.isSavedPosted(act)) {
            this.recalculateTax();
            this.calculateAmount();
        }
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateAmounts(validator);
    }

    protected boolean validateAmounts(Validator validator) {
        List<Act> acts;
        BigDecimal sum;
        boolean result;
        FinancialAct act;
        ActCalculator calc = new ActCalculator((ArchetypeService)ServiceHelper.getArchetypeService());
        BigDecimal total = calc.getTotal(act = this.getObject());
        boolean bl = result = total.compareTo(sum = calc.sum((acts = this.getItems().getActs()).iterator(), "total")) == 0;
        if (!result) {
            String message = Messages.format((String)"act.validation.totalMismatch", (Object[])new Object[]{this.getProperty("amount").getDisplayName(), NumberFormatter.formatCurrency((Number)total), this.getItems().getProperty().getDisplayName(), NumberFormatter.formatCurrency((Number)sum)});
            validator.add((Modifiable)this, new ValidatorError(message));
            if (log.isWarnEnabled()) {
                log.warn(message);
                User user = this.getLayoutContext().getContext().getUser();
                String userName = user != null ? user.getUsername() : null;
                log.warn("username = " + userName + ", act = " + this.format((IMObject)act));
                for (int i = 0; i < acts.size(); ++i) {
                    log.warn("act item (" + (i + 1) + " of " + acts.size() + ") = " + this.format((IMObject)acts.get(i)));
                }
                IMObjectEditor current = this.getItems().getCurrentEditor();
                if (current != null) {
                    log.warn("current act item = " + this.format(current.getObject()));
                }
            }
        }
        return result;
    }

    @Override
    protected void onItemsChanged() {
        this.calculateAmount();
        this.calculateTax();
    }

    private void calculateAmount() {
        Property amount = this.getProperty("amount");
        BigDecimal value = ActHelper.sum((Act)this.getObject(), this.getItems().getCurrentActs(), "total");
        amount.setValue(value);
    }

    private void recalculateTax() {
        Property taxAmount = this.getProperty("tax");
        if (taxAmount != null) {
            ActRelationshipCollectionEditor items = this.getItems();
            List<Act> acts = items.getActs();
            for (Act act : acts) {
                items.getEditor((IMObject)act);
            }
            BigDecimal previousTax = (BigDecimal)taxAmount.getValue();
            BigDecimal tax = ActHelper.sum((Act)this.getObject(), acts, "tax");
            if (tax.compareTo(previousTax) != 0) {
                taxAmount.setValue(tax);
            }
        }
    }

    private boolean isSavedPosted(FinancialAct act) {
        return ActStatusHelper.isPosted((Act)act, (ArchetypeService)this.getService());
    }

    private String format(IMObject object) {
        return new ReflectionToStringBuilder((Object)object, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }
}

