/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.list.ListCellRenderer;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.bound.BoundSelectFieldFactory;
import org.openvpms.web.component.edit.AbstractPropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.list.IMObjectListCellRenderer;
import org.openvpms.web.component.im.list.ObjectListModel;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class SelectFieldIMObjectReferenceEditor<T extends IMObject>
extends AbstractPropertyEditor
implements IMObjectReferenceEditor<T> {
    private final Map<Reference, T> map = new LinkedHashMap<Reference, T>();
    private final SelectField field;
    private final FocusGroup focus;
    private final DelegatingRenderer renderer;

    public SelectFieldIMObjectReferenceEditor(Property property, List<T> objects, boolean all) {
        super(property);
        this.field = BoundSelectFieldFactory.create(property, new ObjectListModel(all, false));
        this.setObjects(objects);
        this.renderer = new DelegatingRenderer();
        this.field.setCellRenderer((ListCellRenderer)this.renderer);
        this.focus = new FocusGroup("SelectFieldIMObjectReferenceEditor", new Component[]{this.field});
    }

    public void setListCellRenderer(ListCellRenderer renderer) {
        this.renderer.setCellRenderer(renderer);
    }

    public void setObjects(List<T> objects) {
        ObjectListModel model = (ObjectListModel)this.field.getModel();
        this.map.clear();
        ArrayList<Reference> list = new ArrayList<Reference>();
        for (IMObject object : objects) {
            Reference reference = object.getObjectReference();
            this.map.put(reference, object);
            list.add(reference);
        }
        model.setObjects(list);
    }

    @Override
    public boolean setObject(T object) {
        Property property = this.getProperty();
        boolean modified = object != null ? property.setValue(object.getObjectReference()) : property.setValue(null);
        return modified;
    }

    @Override
    public T getObject() {
        return (T)((IMObject)this.map.get(this.getProperty().getReference()));
    }

    @Override
    public Component getComponent() {
        return this.field;
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.focus;
    }

    @Override
    public boolean isNull() {
        return this.getProperty().getValue() == null;
    }

    @Override
    public void setAllowCreate(boolean create) {
    }

    @Override
    public boolean allowCreate() {
        return false;
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.isValidReference(validator);
    }

    protected boolean isValidReference(Validator validator) {
        Reference reference = this.getProperty().getReference();
        boolean result = true;
        if (reference != null && !reference.isNew()) {
            result = this.isValidReference(reference, validator);
        }
        return result;
    }

    protected boolean isValidReference(Reference reference, Validator validator) {
        boolean result = this.map.containsKey(reference);
        if (!result) {
            String displayName = DescriptorHelper.getDisplayName((String)reference.getArchetype(), (ArchetypeService)ServiceHelper.getArchetypeService());
            String message = Messages.format((String)"imobject.invalidreference", (Object[])new Object[]{displayName});
            validator.add((Modifiable)this, new ValidatorError(this.getProperty(), message));
        }
        return result;
    }

    private class DelegatingRenderer
    implements ListCellRenderer {
        private ListCellRenderer renderer;

        public DelegatingRenderer() {
            this.setCellRenderer(IMObjectListCellRenderer.NAME);
        }

        public void setCellRenderer(ListCellRenderer renderer) {
            this.renderer = renderer;
        }

        public Object getListCellRendererComponent(Component list, Object value, int index) {
            Reference reference = (Reference)value;
            IMObject object = (IMObject)SelectFieldIMObjectReferenceEditor.this.map.get(reference);
            return this.renderer.getListCellRendererComponent(list, (Object)object, index);
        }
    }
}

