/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.math.BigDecimal;
import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;

public class Quantity {
    private final Property property;
    private final ComponentState state;
    private BigDecimal defaultQuantity;

    public Quantity(Property property, IMObject object, LayoutContext context) {
        this.property = property;
        this.state = context.getComponentFactory().create(property, object);
        property.addModifiableListener(modifiable -> this.onQuantityChanged());
    }

    public BigDecimal getValue() {
        return this.property.getBigDecimal();
    }

    public BigDecimal getValue(BigDecimal defaultValue) {
        return this.property.getBigDecimal(defaultValue);
    }

    public void setValue(BigDecimal value) {
        this.setValue(value, false);
    }

    public void setValue(BigDecimal value, boolean isDefault) {
        this.defaultQuantity = isDefault ? value : null;
        this.property.setValue(value);
        this.setStyle(isDefault);
    }

    public Property getProperty() {
        return this.property;
    }

    public void clearDefault() {
        this.defaultQuantity = null;
        this.setStyle(false);
    }

    public boolean isDefault() {
        BigDecimal value = this.property.getBigDecimal();
        return this.defaultQuantity != null && value != null && MathRules.equals((BigDecimal)value, (BigDecimal)this.defaultQuantity);
    }

    public boolean isNegative() {
        return this.getValue().signum() < 0;
    }

    public ComponentState getState() {
        return this.state;
    }

    public Component getComponent() {
        return this.state.getComponent();
    }

    private void onQuantityChanged() {
        boolean defaultValue = this.isDefault();
        if (!defaultValue) {
            this.defaultQuantity = null;
        }
        this.setStyle(defaultValue);
    }

    private void setStyle(boolean isDefault) {
        String style = isDefault ? "highlight" : "default";
        this.getComponent().setStyleName(style);
    }
}

