/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditorOperation;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorOperation;
import org.openvpms.web.component.im.edit.SaveFailureFormatter;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionTemplate;

public class IMObjectEditorSaver {
    private final IMObjectEditorOperation<IMObjectEditor> strategy;
    private static final Logger log = LoggerFactory.getLogger(IMObjectEditorSaver.class);

    public IMObjectEditorSaver() {
        this(new SaveOperation());
    }

    public IMObjectEditorSaver(IMObjectEditorOperation<IMObjectEditor> strategy) {
        this.strategy = strategy;
    }

    public boolean save(IMObjectEditor editor) {
        return this.save(editor, false);
    }

    public boolean save(IMObjectEditor editor, boolean suppressDialogs) {
        return this.save(editor, suppressDialogs, null);
    }

    public boolean save(IMObjectEditor editor, Runnable listener) {
        return this.save(editor, false, listener);
    }

    protected boolean save(IMObjectEditor editor, boolean suppressDialogs, Runnable listener) {
        boolean result;
        block3: {
            TransactionTemplate template = new TransactionTemplate(ServiceHelper.getTransactionManager());
            try {
                Boolean saved = (Boolean)template.execute(transactionStatus -> this.validateAndSave(editor, listener, suppressDialogs));
                boolean bl = result = saved != null && saved != false;
                if (result) {
                    editor.committed();
                }
            }
            catch (Throwable exception) {
                result = false;
                this.log(editor, exception);
                if (suppressDialogs) break block3;
                this.strategy.failed(editor, exception, listener);
            }
        }
        return result;
    }

    protected Validator createValidator() {
        return new DefaultValidator();
    }

    protected void showError(Validator validator, Runnable listener) {
        ValidationHelper.showError(null, validator, listener);
    }

    private boolean validateAndSave(IMObjectEditor editor, Runnable listener, boolean suppressDialogs) {
        Validator validator = this.createValidator();
        boolean result = editor.validate(validator);
        if (result) {
            this.strategy.apply(editor);
        } else if (!suppressDialogs) {
            this.showError(validator, listener);
        }
        return result;
    }

    private void log(IMObjectEditor editor, Throwable exception) {
        String context = Messages.format((String)"logging.error.editcontext", (Object[])new Object[]{editor.getObject().getObjectReference(), editor.getClass().getName()});
        String message = ErrorFormatter.format(exception, editor.getDisplayName());
        log.error(Messages.format((String)"logging.error.messageandcontext", (Object[])new Object[]{message, context}), exception);
    }

    public static class SaveOperation
    extends AbstractIMObjectEditorOperation<IMObjectEditor> {
        public SaveOperation() {
            super(new SaveFailureFormatter());
        }

        @Override
        public void apply(IMObjectEditor editor) {
            editor.save();
        }
    }
}

