/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.lang.reflect.Constructor;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandlers;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.DefaultIMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.EditableIMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.PaletteIMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.SelectFieldIMObjectCollectionEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMObjectCollectionEditorFactory {
    private static ArchetypeHandlers<IMObjectCollectionEditor> editors;
    private static ArchetypeHandlers<EditableIMObjectCollectionEditor> editable;
    private static final Logger log;

    private IMObjectCollectionEditorFactory() {
    }

    public static IMObjectCollectionEditor create(CollectionProperty property, IMObject object, LayoutContext context) {
        IMObjectCollectionEditor result = null;
        String[] shortNames = property.getArchetypeRange();
        if (shortNames.length == 0) {
            throw new IllegalStateException("Node=" + property.getName() + " of archetype=" + object.getArchetype() + " has an invalid archetype range");
        }
        if (property.isParentChild()) {
            ArchetypeHandler handler = IMObjectCollectionEditorFactory.getEditable().getHandler(shortNames);
            if (handler != null) {
                Class type = handler.getType();
                result = IMObjectCollectionEditorFactory.create(type, property, object, context);
            }
            if (result == null) {
                result = new DefaultIMObjectCollectionEditor(property, object, context);
            }
        } else {
            ArchetypeHandler handler;
            if (property.getMaxCardinality() == 1 && (handler = IMObjectCollectionEditorFactory.getEditors().getHandler(shortNames)) != null) {
                Class type = handler.getType();
                result = IMObjectCollectionEditorFactory.create(type, property, object, context);
            }
            if (result == null) {
                result = property.getMaxCardinality() == 1 ? new SelectFieldIMObjectCollectionEditor(property, object, context) : new PaletteIMObjectCollectionEditor(property, object, context);
            }
        }
        return result;
    }

    private static IMObjectCollectionEditor create(Class type, CollectionProperty collection, IMObject object, LayoutContext context) {
        IMObjectCollectionEditor result = null;
        Constructor ctor = IMObjectCollectionEditorFactory.getConstructor(type, collection, object, context);
        if (ctor != null) {
            try {
                result = (IMObjectCollectionEditor)ctor.newInstance(collection, object, context);
            }
            catch (Throwable throwable) {
                log.error(throwable.getMessage(), throwable);
            }
        } else {
            log.error("No valid constructor found for class: " + type.getName());
        }
        return result;
    }

    private static synchronized ArchetypeHandlers<IMObjectCollectionEditor> getEditors() {
        if (editors == null) {
            editors = new ArchetypeHandlers("IMObjectCollectionEditorFactory.properties", IMObjectCollectionEditor.class, (ArchetypeService)ArchetypeServiceHelper.getArchetypeService());
        }
        return editors;
    }

    private static synchronized ArchetypeHandlers<EditableIMObjectCollectionEditor> getEditable() {
        if (editable == null) {
            editable = new ArchetypeHandlers("EditableIMObjectCollectionEditorFactory.properties", "DefaultEditableIMObjectCollectionEditorFactory.properties", EditableIMObjectCollectionEditor.class, (ArchetypeService)ArchetypeServiceHelper.getArchetypeService());
        }
        return editable;
    }

    private static Constructor getConstructor(Class type, CollectionProperty collection, IMObject object, LayoutContext context) {
        Constructor<?>[] ctors;
        for (Constructor<?> ctor : ctors = type.getConstructors()) {
            Class<?>[] ctorTypes = ctor.getParameterTypes();
            if (ctorTypes.length != 3) continue;
            Class<?> ctorCollection = ctorTypes[0];
            Class<?> ctorObj = ctorTypes[1];
            Class<?> ctorLayout = ctorTypes[2];
            if (!ctorCollection.isAssignableFrom(collection.getClass()) || !ctorObj.isAssignableFrom(object.getClass()) || (context == null || !ctorLayout.isAssignableFrom(context.getClass())) && (context != null || !LayoutContext.class.isAssignableFrom(ctorLayout))) continue;
            return ctor;
        }
        return null;
    }

    static {
        log = LoggerFactory.getLogger(IMObjectCollectionEditorFactory.class);
    }
}

