/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Component;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.bound.AbstractBoundIMObjectComboBox;
import org.openvpms.web.component.bound.Binder;
import org.openvpms.web.component.bound.BoundIMObjectReferenceComboBox;
import org.openvpms.web.component.bound.ComboBoxPropertyEditor;
import org.openvpms.web.component.edit.AbstractPropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.focus.FocusGroup;

public abstract class ComboBoxIMObjectReferenceEditor<T extends IMObject>
extends AbstractPropertyEditor
implements IMObjectReferenceEditor<T> {
    private final LayoutContext layoutContext;
    private ComboBoxPropertyEditor<T> editor;

    public ComboBoxIMObjectReferenceEditor(Property property, LayoutContext context) {
        super(property);
        this.layoutContext = context;
    }

    @Override
    public boolean setObject(T object) {
        return this.updateProperty(object);
    }

    @Override
    public T getObject() {
        IMObject object = null;
        Property property = this.getProperty();
        Reference reference = property.getReference();
        if (reference != null) {
            object = IMObjectHelper.getObject(reference, property.getArchetypeRange(), this.layoutContext.getContext());
        }
        return (T)object;
    }

    @Override
    public Component getComponent() {
        if (this.editor == null) {
            BoundIMObjectReferenceComboBox combo = new BoundIMObjectReferenceComboBox<T>(this.getProperty(), this.getSelectable()){

                @Override
                protected Binder createBinder(Property property) {
                    return new AbstractBoundIMObjectComboBox.IMObjectComboBoxBinder(property){

                        @Override
                        protected boolean updateProperty(Property property, Object object) {
                            return ComboBoxIMObjectReferenceEditor.this.updateProperty((IMObject)object);
                        }
                    };
                }
            };
            this.editor = new ComboBoxPropertyEditor(combo);
        }
        return this.editor.getComponent();
    }

    @Override
    public boolean isNull() {
        return this.getProperty().getValue() == null && StringUtils.isEmpty((CharSequence)this.editor.getComponent().getText());
    }

    @Override
    public void setAllowCreate(boolean create) {
    }

    @Override
    public boolean allowCreate() {
        return false;
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.editor.getFocusGroup();
    }

    protected boolean updateProperty(T value) {
        Property property = this.getProperty();
        boolean modified = value != null ? property.setValue(value.getObjectReference()) : property.setValue(null);
        return modified;
    }

    protected List<T> getSelectable() {
        T current;
        List<T> objects = this.getObjects();
        if (!objects.contains(current = this.getObject())) {
            objects = new ArrayList<T>(objects);
            objects.add(current);
        }
        return objects;
    }

    protected abstract List<T> getObjects();

    protected LayoutContext getContext() {
        return this.layoutContext;
    }
}

