/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.util.List;
import java.util.function.Consumer;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.button.AbstractButton;
import nextapp.echo2.app.event.ActionEvent;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.edit.AlertListener;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditorOperation;
import org.openvpms.web.component.im.edit.AlertManager;
import org.openvpms.web.component.im.edit.EditActions;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorSaver;
import org.openvpms.web.component.im.edit.SaveFailureFormatter;
import org.openvpms.web.component.im.view.Selection;
import org.openvpms.web.component.macro.MacroDialog;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.error.ErrorHandler;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.event.Vetoable;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEditDialog
extends PopupDialog {
    protected static final String STYLE = "EditDialog";
    private final AlertManager alerts;
    private final boolean userSave;
    private final boolean save;
    private final Context context;
    private IMObjectEditor editor;
    private boolean savedDisabled;
    private Component current;
    private String lastArchetype;
    private FocusGroup currentGroup;
    private HelpContext helpContext;
    private Consumer<IMObjectEditor> transactionCallback;
    private Consumer<IMObjectEditor> postSaveCallback;
    private static final Logger log = LoggerFactory.getLogger(AbstractEditDialog.class);

    public AbstractEditDialog(String title, EditActions actions, Context context, HelpContext help) {
        this(null, title, actions, context, help);
    }

    public AbstractEditDialog(IMObjectEditor editor, EditActions actions, Context context) {
        this(editor, editor.getTitle(), actions, context, editor.getHelpContext());
    }

    protected AbstractEditDialog(IMObjectEditor editor, String title, EditActions actions, Context context, HelpContext help) {
        super(title, STYLE, actions.getButtons(), help);
        this.context = context;
        this.save = actions.save();
        this.userSave = this.save && actions.userSave();
        this.alerts = new AlertManager((Component)this.getContentPane(), 2);
        this.setModal(true);
        this.setEditor(editor);
        this.getButtons().addKeyListener(4173, (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AbstractEditDialog.this.onMacro();
            }
        });
        this.setCancelListener(this::onCancel);
    }

    public IMObjectEditor getEditor() {
        return this.editor;
    }

    public void setTransactionCallback(Consumer<IMObjectEditor> callback) {
        this.transactionCallback = callback;
    }

    public void setPostSaveCallback(Consumer<IMObjectEditor> callback) {
        this.postSaveCallback = callback;
    }

    public boolean save() {
        IMObjectEditorSaver saver;
        boolean result = false;
        if (this.canSave() && (result = (saver = new IMObjectEditorSaver(new ReloadingSaveOperation())).save(this.editor))) {
            result = this.postSave();
        }
        return result;
    }

    public void save(boolean close) {
        if (!close) {
            this.onApply();
        } else {
            this.onOK();
        }
    }

    public void addSkip(boolean skip) {
        ButtonSet buttons = this.getButtons();
        AbstractButton button = buttons.getButton("skip");
        if (skip) {
            if (button == null) {
                this.addButton("skip", false);
            }
        } else if (button != null) {
            buttons.remove(button);
        }
    }

    public HelpContext getHelpContext() {
        return this.helpContext != null ? this.helpContext : super.getHelpContext();
    }

    public void close(String action) {
        this.alerts.clear();
        super.close(action);
    }

    protected void resize() {
        String property;
        String archetype;
        IMObjectEditor editor = this.getEditor();
        if (editor != null && !StringUtils.equals((CharSequence)(archetype = editor.getObject().getArchetype()), (CharSequence)this.lastArchetype) && this.resize(property = this.getStyleName() + ".size." + archetype)) {
            this.lastArchetype = archetype;
        }
    }

    protected void doLayout() {
        FocusGroup group;
        super.doLayout();
        if (this.editor != null && (group = this.editor.getFocusGroup()) != null) {
            group.setFocus();
        }
    }

    protected boolean canSave() {
        return !this.savedDisabled && this.save && this.editor != null;
    }

    protected void onApply() {
        if (this.userSave) {
            this.save();
        }
    }

    protected void onOK() {
        if (this.userSave) {
            if (this.save()) {
                this.close("ok");
            }
        } else if (this.editor != null) {
            DefaultValidator validator = new DefaultValidator();
            int newAlerts = this.alerts.getAlertCount();
            if (!this.editor.validate(validator)) {
                ValidationHelper.showError(validator);
            } else if (newAlerts == this.alerts.getAlertCount()) {
                this.close("ok");
            }
        } else {
            this.close("ok");
        }
    }

    protected void doCancel() {
        if (this.editor != null) {
            this.editor.cancel();
        }
        super.doCancel();
    }

    protected void setEditor(IMObjectEditor editor) {
        IMObjectEditor previous = this.editor;
        List<Selection> path = editor != null && previous != null ? previous.getSelectionPath() : null;
        this.setEditor(editor, path);
    }

    protected void setEditor(IMObjectEditor editor, List<Selection> path) {
        IMObjectEditor previous = this.editor;
        if (editor != null) {
            this.setTitle(editor.getTitle());
            editor.addPropertyChangeListener("component", event -> this.onComponentChange());
        }
        this.editor = editor;
        if (previous != null) {
            this.removeEditor(previous);
        } else {
            path = null;
        }
        if (editor != null) {
            this.addEditor(editor);
            if (path != null) {
                editor.setSelectionPath(path);
            }
        }
    }

    protected void doSave(IMObjectEditor editor) {
        editor.save();
        if (this.transactionCallback != null) {
            this.transactionCallback.accept(editor);
        }
    }

    protected boolean postSave() {
        boolean result = false;
        if (this.postSaveCallback == null) {
            result = true;
        } else {
            try {
                this.postSaveCallback.accept(this.editor);
                result = true;
            }
            catch (Throwable exception) {
                String displayName = this.editor.getDisplayName();
                String title = Messages.format((String)"imobject.save.failed", (Object[])new Object[]{displayName});
                ErrorHelper.show(title, displayName, this.editor.getObject(), exception);
                this.saveFailed();
            }
        }
        return result;
    }

    protected boolean reload(IMObjectEditor editor) {
        IMObjectEditor newEditor = null;
        try {
            newEditor = editor.newInstance();
            if (newEditor != null) {
                if (newEditor.getClass() == editor.getClass()) {
                    this.setEditor(newEditor);
                } else {
                    log.error("Cannot reload editor. Reloaded editor=" + newEditor.getClass().getName() + " is a different type to the original editor=" + editor.getClass().getName());
                }
            }
        }
        catch (Throwable exception) {
            log.error("Failed to reload editor", exception);
        }
        return newEditor != null;
    }

    protected void reloaded(String title, String message, IMObjectEditor oldEditor) {
        ErrorHandler.getInstance().error(title, message, null, null);
    }

    protected void saveFailed() {
        this.savedDisabled = true;
        ButtonSet buttons = this.getButtons();
        for (Component component : buttons.getContainer().getComponents()) {
            Button button;
            if (!(component instanceof Button) || "cancel".equals((button = (Button)component).getId())) continue;
            buttons.setEnabled(button.getId(), false);
        }
    }

    protected void addEditor(IMObjectEditor editor) {
        this.setComponent(editor.getComponent(), editor.getFocusGroup(), editor.getHelpContext());
        editor.setAlertListener(this.getAlertListener());
        this.resize();
    }

    protected void removeEditor(IMObjectEditor editor) {
        editor.setAlertListener(null);
        this.removeComponent();
    }

    protected void setComponent(Component component, FocusGroup group, HelpContext context) {
        this.setComponent(component, group, context, true);
    }

    protected void setComponent(Component component, FocusGroup group, HelpContext context, boolean focus) {
        SplitPane layout = this.getLayout();
        if (this.current != null) {
            layout.remove(this.current);
        }
        if (this.currentGroup != null) {
            this.getFocusGroup().remove(this.currentGroup);
        }
        layout.add(component);
        this.getFocusGroup().add(0, group);
        if (focus && this.getParent() != null) {
            group.setFocus();
        }
        this.current = component;
        this.currentGroup = group;
        this.helpContext = context;
    }

    protected void removeComponent() {
        if (this.current != null) {
            this.getLayout().remove(this.current);
            this.current = null;
        }
        this.alerts.clear();
        if (this.currentGroup != null) {
            this.getFocusGroup().remove(this.currentGroup);
            this.currentGroup = null;
        }
        this.helpContext = null;
    }

    protected AlertListener getAlertListener() {
        return this.alerts.getListener();
    }

    protected Context getContext() {
        return this.context;
    }

    protected void onMacro() {
        MacroDialog dialog = new MacroDialog(this.context, this.getHelpContext());
        dialog.show();
    }

    protected boolean isSaveDisabled() {
        return this.savedDisabled;
    }

    private void onComponentChange() {
        this.setComponent(this.editor.getComponent(), this.editor.getFocusGroup(), this.editor.getHelpContext(), false);
    }

    private void onCancel(Vetoable action) {
        action.veto(false);
    }

    private class ReloadingSaveOperation
    extends ReloadingEditorOperation<IMObjectEditor> {
        public ReloadingSaveOperation() {
            super(new SaveFailureFormatter());
        }

        @Override
        public void apply(IMObjectEditor editor) {
            AbstractEditDialog.this.doSave(editor);
        }
    }

    protected abstract class ReloadingEditorOperation<T extends IMObjectEditor>
    extends AbstractIMObjectEditorOperation<T> {
        public ReloadingEditorOperation(AbstractIMObjectEditorOperation.FailureFormatter formatter) {
            super(formatter);
        }

        @Override
        protected boolean reload(T editor) {
            return AbstractEditDialog.this.reload((IMObjectEditor)editor);
        }

        @Override
        protected void reloaded(String title, String message, T oldEditor, Runnable listener) {
            AbstractEditDialog.this.reloaded(title, message, (IMObjectEditor)oldEditor);
        }

        @Override
        protected void unrecoverableFailure(T editor, Throwable exception, Runnable listener) {
            super.unrecoverableFailure(editor, exception, listener);
            AbstractEditDialog.this.saveFailed();
        }
    }
}

