/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.CollectionResultSetFactory;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.IMObjectListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMObjectTableModelFactory;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.view.TableComponentFactory;

public abstract class AbstractCollectionResultSetFactory
implements CollectionResultSetFactory {
    @Override
    public ResultSet<IMObject> createResultSet(CollectionPropertyEditor property, Context context) {
        return new IMObjectListResultSet<IMObject>(property.getObjects(), 15);
    }

    @Override
    public IMTableModel<IMObject> createTableModel(CollectionPropertyEditor property, IMObject parent, LayoutContext context) {
        context = new DefaultLayoutContext(context);
        context.setComponentFactory(new TableComponentFactory(context));
        String[] shortNames = property.getArchetypeRange();
        if (shortNames.length == 0) {
            throw new IllegalStateException("Node=" + property.getProperty().getName() + " of archetype=" + parent.getArchetype() + " has an invalid archetype range");
        }
        return IMObjectTableModelFactory.create(shortNames, parent, context);
    }
}

