/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import nextapp.echo2.app.Extent;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.doc.AbstractDocumentTemplateLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.text.TextArea;

public class EmailDocumentTemplateLayoutStrategy
extends AbstractDocumentTemplateLayoutStrategy {
    public EmailDocumentTemplateLayoutStrategy() {
    }

    public EmailDocumentTemplateLayoutStrategy(ComponentState content) {
        super(content);
    }

    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        IMObjectBean bean = this.getBean(object);
        if ("DOCUMENT".equals(bean.getString("contentType"))) {
            ComponentState content = this.getContent();
            if (content == null) {
                content = this.initContent((Entity)object, properties, context);
            }
            this.addComponent(content);
        }
        this.addTextArea("subject", properties, object, context);
        this.addTextArea("subjectSource", properties, object, context);
        this.addTextArea("contentSource", properties, object, context);
        return super.apply(object, properties, parent, context);
    }

    private void addTextArea(String name, PropertySet properties, IMObject object, LayoutContext context) {
        Property property = properties.get(name);
        ComponentState state = context.getComponentFactory().create(property, object);
        if (state.getComponent() instanceof TextArea) {
            TextArea component = (TextArea)state.getComponent();
            component.setWidth(new Extent(50, 128));
            component.setHeight(new Extent(2, 64));
        }
        this.addComponent(state);
    }
}

