/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import java.util.List;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.doc.DocumentTemplateQuery;
import org.openvpms.web.component.im.edit.AbstractIMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.EntityResultSet;
import org.openvpms.web.component.im.query.FilteredResultSet;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.relationship.EntityLinkEditor;
import org.openvpms.web.component.property.Property;

public class EmailDocumentTemplateAttachmentEditor
extends EntityLinkEditor {
    public EmailDocumentTemplateAttachmentEditor(EntityLink relationship, IMObject parent, LayoutContext context) {
        super(relationship, parent, context);
    }

    @Override
    protected IMObjectReferenceEditor<Entity> createTargetEditor(Property property, LayoutContext context) {
        return new AbstractIMObjectReferenceEditor<Entity>(property, this.getObject(), context){

            @Override
            protected Query<Entity> createQuery(String name) {
                StaticFormTemplateQuery query = new StaticFormTemplateQuery();
                query.setValue(name);
                return query;
            }
        };
    }

    private static class StaticFormTemplateQuery
    extends DocumentTemplateQuery {
        public StaticFormTemplateQuery() {
            this.setTemplateTypes("act.patientDocumentForm", "act.customerDocumentForm", "act.supplierDocumentForm");
        }

        @Override
        public boolean selects(Reference reference) {
            boolean result;
            ResultSet<Entity> set = super.createResultSet(null);
            if (set instanceof EntityResultSet) {
                EntityResultSet entityResultSet = (EntityResultSet)set;
                entityResultSet.setReferenceConstraint(reference);
                ResultSet<Entity> filteredResultSet = this.getFilteredResultSet(entityResultSet);
                result = filteredResultSet.hasNext();
            } else {
                result = false;
            }
            return result;
        }

        @Override
        protected ResultSet<Entity> createResultSet(SortConstraint[] sort) {
            return this.getFilteredResultSet(super.createResultSet(sort));
        }

        private ResultSet<Entity> getFilteredResultSet(ResultSet<Entity> set) {
            return new FilteredResultSet<Entity>(set){

                @Override
                protected void filter(Entity object, List<Entity> results) {
                    DocumentTemplate template = new DocumentTemplate(object, this.getService());
                    if ("application/pdf".equals(template.getMimeType())) {
                        results.add(object);
                    }
                }
            };
        }
    }
}

