/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.im.doc.DocumentActDownloader;
import org.openvpms.web.component.im.doc.DocumentRefDownloader;
import org.openvpms.web.component.im.doc.Downloader;
import org.openvpms.web.component.im.doc.DownloaderListener;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class DocumentViewer {
    private final IArchetypeService service;
    private final Reference reference;
    private final IMObject parent;
    private final String name;
    private final boolean link;
    private final boolean template;
    private final LayoutContext context;
    private Downloader downloader;
    private DownloaderListener listener;
    private boolean showNoDocument = true;
    private int nameLength = -1;
    private IMObjectBean bean;
    private static final String DOCUMENT_TEMPLATE = "documentTemplate";

    public DocumentViewer(DocumentAct act, boolean link, LayoutContext context) {
        this(act, link, false, context);
    }

    public DocumentViewer(DocumentAct act, boolean link, boolean template, LayoutContext context) {
        this(act.getDocument(), (IMObject)act, act.getFileName(), link, template, context);
    }

    public DocumentViewer(Reference reference, IMObject parent, boolean link, LayoutContext context) {
        this(reference, parent, null, link, false, context);
    }

    public DocumentViewer(Reference reference, IMObject parent, boolean link, boolean template, LayoutContext context) {
        this(reference, parent, null, link, template, context);
    }

    public DocumentViewer(Reference reference, IMObject parent, String name, boolean link, boolean template, LayoutContext context) {
        this.reference = reference;
        this.parent = parent;
        this.service = ServiceHelper.getArchetypeService();
        this.name = name != null ? name : (parent instanceof DocumentAct ? ((DocumentAct)parent).getFileName() : (reference != null ? DescriptorHelper.getDisplayName((String)reference.getArchetype(), (ArchetypeService)this.service) : null));
        this.link = link;
        this.template = template;
        this.context = context;
    }

    public void setDownloadListener(DownloaderListener listener) {
        if (this.downloader != null) {
            this.downloader.setListener(listener);
        } else {
            this.listener = listener;
        }
    }

    public void setShowNoDocument(boolean show) {
        this.showNoDocument = show;
    }

    public Component getComponent() {
        Component result = this.getDocument();
        if (result == null) {
            result = this.getPlaceholder();
        }
        return result;
    }

    public void setNameLength(int length) {
        if (this.downloader != null) {
            this.downloader.setNameLength(length);
        } else {
            this.nameLength = length;
        }
    }

    protected Component getDocument() {
        Component result = null;
        boolean hasDoc = false;
        if (this.reference != null) {
            hasDoc = true;
        } else if (this.parent != null) {
            IMObjectBean bean = this.getBean();
            hasDoc = bean.hasNode(DOCUMENT_TEMPLATE);
        }
        if (hasDoc) {
            if (this.link) {
                this.downloader = this.getDownloader();
                result = this.downloader.getComponent();
            } else {
                Label label = LabelFactory.create();
                label.setText(this.name);
                result = label;
            }
        }
        return result;
    }

    protected Component getPlaceholder() {
        Label label = LabelFactory.create();
        if (this.showNoDocument) {
            label.setText(Messages.get((String)"document.none"));
        }
        Label result = label;
        return result;
    }

    protected IMObject getParent() {
        return this.parent;
    }

    protected Downloader getDownloader() {
        Downloader result = this.createDownloader();
        result.setNameLength(this.nameLength);
        result.setListener(this.listener);
        return result;
    }

    protected Downloader createDownloader() {
        Downloader result = this.parent instanceof DocumentAct ? new DocumentActDownloader((DocumentAct)this.parent, this.template, this.context.getContext(), ServiceHelper.getBean(FileNameFormatter.class), ServiceHelper.getBean(ReportFactory.class)) : new DocumentRefDownloader(this.reference, this.name, this.getContext().getContext().getUser());
        return result;
    }

    protected boolean link() {
        return this.link;
    }

    protected LayoutContext getContext() {
        return this.context;
    }

    protected IMObjectBean getBean() {
        if (this.bean == null && this.parent != null) {
            this.bean = this.service.getBean(this.parent);
        }
        return this.bean;
    }
}

