/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import org.openvpms.archetype.rules.doc.TextDocumentHandler;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.macro.Macros;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.StringPropertyTransformer;
import org.openvpms.web.system.ServiceHelper;

public class DocumentBackedTextNodeEditor {
    private final Property text;
    private final SimpleProperty textProxy;
    private final Property document;
    private final TextDocumentHandler handler;

    public DocumentBackedTextNodeEditor(DocumentAct act, Property text, Property document, LayoutContext context) {
        Document content;
        this.text = text;
        this.document = document;
        this.textProxy = new SimpleProperty(text.getName(), String.class);
        this.textProxy.setMaxLength(-1);
        this.textProxy.setDisplayName(text.getDisplayName());
        Macros macros = ServiceHelper.getMacros();
        this.textProxy.setTransformer(new StringPropertyTransformer(this.textProxy, false, macros, act, context.getVariables()));
        text.setTransformer(new StringPropertyTransformer(text, false));
        this.handler = new TextDocumentHandler((ArchetypeService)ServiceHelper.getArchetypeService());
        this.textProxy.setValue(text.getValue());
        if (!act.isNew() && (content = this.getDocument()) != null) {
            this.textProxy.setValue(this.handler.toString(content));
        }
        this.textProxy.clearModified();
    }

    public boolean isModified() {
        return this.textProxy.isModified();
    }

    public Property getText() {
        return this.textProxy;
    }

    public void save(Runnable saveParent) {
        String value = this.textProxy.getString();
        boolean deleteDoc = false;
        Document content = this.getDocument();
        if (value == null || value.length() <= this.text.getMaxLength()) {
            this.text.setValue(value);
            this.document.setValue(null);
            if (content != null) {
                deleteDoc = true;
            }
        } else {
            this.text.setValue(null);
            if (content == null) {
                content = this.handler.create(this.text.getName(), value);
                this.document.setValue(content.getObjectReference());
            } else {
                this.handler.update(content, value);
            }
            ServiceHelper.getArchetypeService().save((IMObject)content);
        }
        saveParent.run();
        if (deleteDoc) {
            ServiceHelper.getArchetypeService().remove((IMObject)content);
        }
    }

    private Document getDocument() {
        return (Document)IMObjectHelper.getObject(this.document.getReference());
    }
}

