/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.doc.DocumentActEditor;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;

public class DocumentActEditDialog
extends EditDialog {
    public DocumentActEditDialog(DocumentActEditor editor, Context context) {
        super(editor, context);
    }

    @Override
    public DocumentActEditor getEditor() {
        return (DocumentActEditor)super.getEditor();
    }

    @Override
    protected void onApply() {
        if (this.documentOutOfDate()) {
            this.generateDocument(() -> DocumentActEditDialog.super.onApply());
        } else {
            super.onApply();
        }
    }

    @Override
    protected void onOK() {
        if (this.documentOutOfDate()) {
            this.generateDocument(() -> DocumentActEditDialog.super.onOK());
        } else {
            super.onOK();
        }
    }

    private void generateDocument(Runnable listener) {
        DocumentActEditor editor = this.getEditor();
        if (editor.getDocumentStatus() == DocumentActEditor.DocumentStatus.NEEDS_UPDATE) {
            this.generateDocument(editor, listener);
        } else if (editor.getDocumentStatus() == DocumentActEditor.DocumentStatus.PROMPT) {
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().titleKey("document.update.title", new Object[0])).messageKey("document.update.message", new Object[0])).yesNoCancel()).yes(() -> this.generateDocument(editor, listener))).no(() -> {
                editor.resetDocumentStatus();
                listener.run();
            })).show();
        } else {
            listener.run();
        }
    }

    private void generateDocument(DocumentActEditor editor, Runnable listener) {
        editor.generateDocument((Boolean success) -> {
            if (success != null && success.booleanValue()) {
                listener.run();
            }
        });
    }

    private boolean documentOutOfDate() {
        DocumentActEditor editor = this.getEditor();
        return this.canSave() && editor != null && editor.getDocumentStatus() != DocumentActEditor.DocumentStatus.UP_TO_DATE;
    }
}

