/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.TemplateHelper;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.doc.DocReferenceMgr;
import org.openvpms.web.component.im.doc.DocumentUploadListener;
import org.openvpms.web.component.im.doc.UploadDialog;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.select.BasicSelector;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.event.ActionListener;

public class AbstractDocumentTemplateEditor
extends AbstractIMObjectEditor {
    private static final DateTimeFormatter REVISION_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final BasicSelector<DocumentAct> selector;
    private final SimpleProperty content = new SimpleProperty("content", IMObjectReference.class);
    private final DocReferenceMgr refMgr;
    private DocumentHandler handler;
    private DocumentAct act;
    private boolean docModified = false;
    private boolean deleteDocOnSave;
    private static final String REVISION = "revision";

    public AbstractDocumentTemplateEditor(Entity template, IMObject parent, boolean docRequired, DocumentHandler handler, LayoutContext context) {
        super((IMObject)template, parent, context);
        this.setDocumentRequired(docRequired);
        this.handler = handler;
        this.refMgr = new DocReferenceMgr((ArchetypeService)this.getService());
        this.getDocumentAct();
        this.content.setValue(this.act.getDocument());
        this.selector = new BasicSelector("button.upload");
        this.selector.getSelect().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AbstractDocumentTemplateEditor.this.onUpload();
            }
        });
        this.updateDisplay(this.act);
    }

    @Override
    public boolean isModified() {
        return super.isModified() || this.docModified;
    }

    @Override
    public void clearModified() {
        super.clearModified();
        this.docModified = false;
    }

    @Override
    public void cancel() {
        super.cancel();
        try {
            this.refMgr.rollback();
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show(exception);
        }
    }

    protected void setDocumentHandler(DocumentHandler handler) {
        this.handler = handler;
    }

    protected DocumentHandler getDocumentHandler() {
        return this.handler;
    }

    protected DocumentAct getDocumentAct() {
        if (this.act == null) {
            TemplateHelper helper = new TemplateHelper((ArchetypeService)this.getService());
            this.act = helper.getDocumentAct((Entity)this.getObject());
            if (this.act == null) {
                this.act = this.createDocumentAct();
                IMObjectBean bean = this.getBean((IMObject)this.act);
                bean.setTarget("template", this.getObject());
            } else if (this.act.getDocument() != null) {
                this.refMgr.add(this.act.getDocument());
            }
        }
        return this.act;
    }

    protected DocumentAct createDocumentAct() {
        return this.create("act.documentTemplate", DocumentAct.class);
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateContent(validator);
    }

    protected void setDocumentRequired(boolean required) {
        this.content.setRequired(required);
    }

    protected boolean isDocumentRequired() {
        return this.content.isRequired();
    }

    protected void setDeleteDocument(boolean delete) {
        this.deleteDocOnSave = delete;
    }

    @Override
    protected void saveChildren() {
        super.saveChildren();
        if (this.deleteDocOnSave) {
            if (this.isDocumentRequired()) {
                throw new IllegalStateException("Document is required but has been flagged for deletion");
            }
            if (this.act != null && !this.act.isNew()) {
                this.getService().remove((IMObject)this.act);
                this.act = null;
            }
            this.refMgr.delete();
        } else if (this.act != null && this.docModified) {
            this.getService().save((IMObject)this.act);
            this.refMgr.commit();
            this.docModified = false;
        }
    }

    @Override
    protected void doDelete() {
        this.getService().remove((IMObject)this.act);
        this.act = null;
        super.doDelete();
    }

    @Override
    protected void deleteChildren() {
        super.deleteChildren();
        this.refMgr.delete();
    }

    protected ComponentState getSelector() {
        return new ComponentState(this.selector.getComponent(), this.content);
    }

    protected void enableUpload(boolean enable) {
        this.selector.getSelect().setEnabled(enable);
    }

    protected void onUpload() {
        DocumentUploadListener listener = new DocumentUploadListener(this.handler){

            @Override
            protected void upload(Document doc) {
                AbstractDocumentTemplateEditor.this.onUpload(doc);
            }
        };
        UploadDialog dialog = new UploadDialog(listener, this.getLayoutContext().getHelpContext());
        dialog.show();
    }

    protected void onUpload(Document document) {
        this.getService().save((IMObject)document);
        this.getDocumentAct();
        this.populateDocumentAct(this.act, document);
        this.replaceDocReference(document);
        this.updateRevision();
        this.updateDisplay(this.act);
        this.docModified = true;
    }

    protected void populateDocumentAct(DocumentAct act, Document document) {
        act.setFileName(document.getName());
        this.getService().deriveValue((IMObject)act, "name");
        act.setMimeType(document.getMimeType());
        if (this.getParent() == null) {
            act.setDescription(document.getDescription());
        } else {
            act.setDescription(this.getParent().getName());
        }
    }

    protected void updateDisplay(DocumentAct act) {
        this.selector.setObject(act);
    }

    protected InputStream getContent() {
        Document document;
        InputStream result = null;
        Reference reference = this.getDocumentAct().getDocument();
        if (reference != null && (document = (Document)this.getService().get(reference, Document.class)) != null) {
            result = this.getContent(document);
        }
        return result;
    }

    protected InputStream getContent(Document document) {
        return this.handler.getContent(document);
    }

    protected boolean validateContent(String fileName, String mimeType, Validator validator, Property content) {
        boolean valid = this.isContentSupported(fileName, mimeType);
        if (!valid) {
            validator.add((Modifiable)content, new DocumentException(DocumentException.ErrorCode.UnsupportedDoc, new Object[]{fileName, mimeType}).getMessage());
        }
        return valid;
    }

    protected boolean isContentSupported(String fileName, String mimeType) {
        return this.handler.canHandle(fileName, mimeType);
    }

    private boolean validateContent(Validator validator) {
        boolean valid = this.content.validate(validator);
        if (valid && this.content.getReference() != null) {
            DocumentAct act = this.getDocumentAct();
            String fileName = act.getFileName();
            String mimeType = act.getMimeType();
            valid = this.validateContent(fileName, mimeType, validator, this.content);
        }
        return valid;
    }

    private void replaceDocReference(Document document) {
        Reference ref = document.getObjectReference();
        this.act.setDocument(ref);
        this.refMgr.add(ref);
        this.content.setValue(ref);
    }

    private void updateRevision() {
        Property revision = this.getProperty(REVISION);
        if (revision != null) {
            String value = REVISION_FORMAT.format(LocalDateTime.now());
            revision.setValue(value);
        }
    }
}

