/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.delete;

import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.delete.AbstractIMObjectDeleter;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandler;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.component.im.delete.IMObjectDeletionListener;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;

public class ConfirmingDeleter<T extends IMObject>
extends AbstractIMObjectDeleter<T> {
    public ConfirmingDeleter(IMObjectDeletionHandlerFactory factory, ArchetypeService service) {
        super(factory, service);
    }

    @Override
    protected void delete(IMObjectDeletionHandler<T> handler, Context context, HelpContext help, IMObjectDeletionListener<T> listener) {
        T object = handler.getObject();
        String type = this.getDisplayName((IMObject)object);
        String name = object.getName() != null ? object.getName() : type;
        ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().titleKey("imobject.delete.title", new Object[]{type})).messageKey("imobject.delete.message", new Object[]{name})).ok(true, () -> this.doDelete(handler, context, help, listener))).cancel()).help(help)).show();
    }

    @Override
    protected void deactivate(IMObjectDeletionHandler<T> handler, IMObjectDeletionListener<T> listener, HelpContext help) {
        T object = handler.getObject();
        String type = this.getDisplayName((IMObject)object);
        String name = object.getName() != null ? object.getName() : type;
        ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().titleKey("imobject.deactivate.title", new Object[]{type})).messageKey("imobject.deactivate.message", new Object[]{name})).ok(true, () -> this.doDeactivate(handler, listener))).cancel()).help(help)).show();
    }

    @Override
    protected void deactivated(T object, HelpContext help, IMObjectDeletionListener<T> listener) {
        ((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().messageKey("imobject.delete.deactivated", new Object[]{this.getDisplayName((IMObject)object), object.getName()})).help(help)).listener(() -> listener.alreadyDeactivated(object))).show();
    }

    @Override
    protected void unsupported(T object, String reason, IMObjectDeletionListener<T> listener) {
        String type = this.getDisplayName((IMObject)object);
        String message = reason == null ? Messages.format((String)"imobject.delete.unsupported", (Object[])new Object[]{this.getDisplayName((IMObject)object)}) : reason;
        ((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().titleKey("imobject.delete.title", new Object[]{type})).message(message)).listener(() -> listener.unsupported(object, reason))).show();
    }
}

