/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.customer;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import org.apache.commons.lang.StringUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.im.query.AbstractEntityQuery;
import org.openvpms.web.component.im.query.AbstractQueryState;
import org.openvpms.web.component.im.query.QueryState;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.echo.text.TextField;

public abstract class CustomerPatientObjectSetQuery
extends AbstractEntityQuery<ObjectSet> {
    private final boolean checkPatientIdentity;
    private Reference customerRef;
    private TextField patient;
    private TextField contact;

    public CustomerPatientObjectSetQuery(String[] shortNames, boolean checkCustomerIdentity, Party customer) {
        super(shortNames, checkCustomerIdentity, Party.class);
        boolean bl = this.checkPatientIdentity = !checkCustomerIdentity;
        if (customer != null) {
            this.setValue(customer.getName());
            this.customerRef = customer.getObjectReference();
        }
    }

    @Override
    public boolean isAuto() {
        return this.getValue() != null || !StringUtils.isEmpty((String)this.getPatient().getText());
    }

    public void setPatient(String value) {
        this.getPatient().setText(value);
    }

    public void setContact(String value) {
        this.getContact().setText(value);
    }

    @Override
    public boolean selects(IMObject object) {
        return this.selects(object.getObjectReference());
    }

    @Override
    public void setQueryState(QueryState state) {
        Memento memento = (Memento)state;
        this.setValue(memento.customer);
        this.customerRef = memento.customerRef;
        this.setPatient(memento.patient);
        this.setContact(memento.contact);
        this.getIdentitySearch().setSelected(memento.identity);
        this.setActive(memento.active);
    }

    @Override
    public Extent getHeight() {
        return this.getHeight(2);
    }

    public void setCustomer(Party customer) {
        if (customer != null) {
            this.getPatient().setText(customer.getName());
            this.customerRef = customer.getObjectReference();
        } else {
            this.getPatient().setText(null);
        }
    }

    public Reference getCustomer() {
        return this.customerRef;
    }

    @Override
    protected void onSearchFieldChanged() {
        this.onCustomerChanged();
        super.onSearchFieldChanged();
    }

    @Override
    protected Component createContainer() {
        return GridFactory.create((int)6);
    }

    @Override
    protected void doLayout(Component container) {
        this.addShortNameSelector(container);
        this.addSearchField(container);
        this.addPatient(container);
        this.addContact(container);
        this.addIdentitySearch(container);
        this.addActive(container);
        if (this.customerRef == null) {
            FocusHelper.setFocus((Component)this.getSearchField());
        } else {
            FocusHelper.setFocus((Component)this.getPatient());
        }
    }

    @Override
    protected void addSearchField(Component container) {
        Label label = LabelFactory.create((String)"customerpatientquery.customer");
        container.add((Component)label);
        TextField field = this.getSearchField();
        container.add((Component)field);
        this.getFocusGroup().add((Component)field);
    }

    protected void addContact(Component container) {
        TextField field = this.getContact();
        container.add((Component)LabelFactory.create((String)"customerpatientquery.contact"));
        container.add((Component)field);
        this.getFocusGroup().add((Component)field);
    }

    protected TextField getPatient() {
        if (this.patient == null) {
            this.patient = TextComponentFactory.create();
            this.patient.addPropertyChangeListener(evt -> this.onPatientChanged());
            this.patient.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    CustomerPatientObjectSetQuery.this.onQuery();
                }
            });
        }
        return this.patient;
    }

    protected TextField getContact() {
        if (this.contact == null) {
            this.contact = TextComponentFactory.create();
            this.contact.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    CustomerPatientObjectSetQuery.this.onQuery();
                }
            });
        }
        return this.contact;
    }

    private void addPatient(Component container) {
        TextField field = this.getPatient();
        container.add((Component)LabelFactory.create((String)"customerpatientquery.patient"));
        container.add((Component)field);
        this.getFocusGroup().add((Component)field);
    }

    private void onCustomerChanged() {
        this.customerRef = null;
    }

    private void onPatientChanged() {
        if (this.checkPatientIdentity) {
            this.checkIdentityName(this.getPatient().getText());
        }
    }

    protected static abstract class Memento
    extends AbstractQueryState {
        private final Reference customerRef;
        private final String customer;
        private final String patient;
        private final String contact;
        private final BaseArchetypeConstraint.State active;
        private final boolean identity;

        public Memento(CustomerPatientObjectSetQuery query) {
            super(query);
            this.customerRef = query.getCustomer();
            this.customer = query.getValue();
            this.patient = query.getPatient().getText();
            this.contact = query.getContact().getText();
            this.active = query.getActive();
            this.identity = query.isIdentitySearch();
        }
    }
}

