/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.contact;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.lookup.DropdownLookupPropertyEditor;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.table.DefaultDescriptorTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.system.ServiceHelper;

public class SuburbLookupPropertyEditor
extends DropdownLookupPropertyEditor {
    public SuburbLookupPropertyEditor(Property property, IMObject parent, LayoutContext context) {
        super(property, parent, context);
    }

    @Override
    protected LookupQuery createLookupQuery(Property property, IMObject object) {
        return new SuburbLookupQuery(object, property);
    }

    @Override
    protected IMTableModel<Lookup> createTableModel(LayoutContext context) {
        return new DefaultDescriptorTableModel<Lookup>("lookup.suburb", context, "name", "postCode");
    }

    @Override
    protected boolean matches(Lookup lookup, String text) {
        IMObjectBean bean;
        String postcode;
        boolean result = super.matches(lookup, text);
        if (!result && (postcode = (bean = ServiceHelper.getArchetypeService().getBean((org.openvpms.component.model.object.IMObject)lookup)).getString("postCode")) != null) {
            result = StringUtils.contains((CharSequence)postcode, (CharSequence)text);
        }
        return result;
    }

    private static class SuburbLookupQuery
    extends NodeLookupQuery {
        public SuburbLookupQuery(IMObject object, Property property) {
            super((org.openvpms.component.model.object.IMObject)object, property);
        }

        @Override
        public List<org.openvpms.component.model.lookup.Lookup> getLookups() {
            List<org.openvpms.component.model.lookup.Lookup> lookups = super.getLookups();
            if (lookups.isEmpty()) {
                lookups = new ArrayList<org.openvpms.component.model.lookup.Lookup>(ServiceHelper.getLookupService().getLookups("lookup.suburb"));
                this.sort(lookups);
            }
            return lookups;
        }
    }
}

