/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.contact;

import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Row;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.contact.AbstractContactViewLayout;
import org.openvpms.web.component.im.contact.EmailLauncher;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.RowFactory;

public class EmailContactViewLayout
extends AbstractContactViewLayout {
    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        ComponentState emailAddress = this.createEmail(properties.get("emailAddress"), (Contact)object, context);
        if (emailAddress != null) {
            this.addComponent(emailAddress);
        }
        return super.apply(object, properties, parent, context);
    }

    private ComponentState createEmail(Property property, Contact contact, LayoutContext context) {
        EmailLauncher launcher;
        ComponentState result = null;
        MailContext mailContext = context.getMailContext();
        if (mailContext != null && (launcher = EmailLauncher.create(contact, (ArchetypeService)this.getService(), context.getContext(), context.getHelpContext(), mailContext)) != null) {
            Button writeButton = launcher.getWriteButton();
            Row row = RowFactory.create((String)"WideCellSpacing", (Component[])new Component[]{writeButton});
            Component mailTo = launcher.getMailToLink();
            if (mailTo != null) {
                row.add(mailTo);
            }
            result = new ComponentState((Component)row, property);
        }
        return result;
    }
}

