/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.clinician;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.archetype.rules.user.UserQueryFactory;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.query.EntityObjectSetQuery;
import org.openvpms.web.component.im.query.EntityObjectSetResultSet;
import org.openvpms.web.component.im.query.EntityQuery;
import org.openvpms.web.component.im.query.QueryFactory;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.LabelFactory;

public class ClinicianQuery
extends EntityQuery<User> {
    public ClinicianQuery(Context context) {
        this(new String[]{"security.user"}, context);
    }

    public ClinicianQuery(String[] shortNames, Context context) {
        super(new ClinicianObjectSetQuery(shortNames, context.getLocation(), context.getPractice()), context);
        QueryFactory.initialise(this);
    }

    public void setAllLocations(boolean allLocations) {
        ClinicianObjectSetQuery query = (ClinicianObjectSetQuery)this.getQuery();
        if (query.allLocations != null) {
            query.allLocations.setSelected(allLocations);
        }
    }

    public void setActive(BaseArchetypeConstraint.State state) {
        ClinicianObjectSetQuery query = (ClinicianObjectSetQuery)this.getQuery();
        query.setActive(state);
    }

    private static class ClinicianResultSet
    extends EntityObjectSetResultSet {
        private final Party location;

        public ClinicianResultSet(ShortNameConstraint archetypes, String value, boolean searchIdentities, SortConstraint[] sort, int rows, boolean distinct, Party location) {
            super(archetypes, value, searchIdentities, sort, rows, distinct);
            this.location = location;
        }

        @Override
        protected ArchetypeQuery createQuery() {
            ArchetypeQuery query = super.createQuery();
            UserQueryFactory.addClinicianConstraint((ArchetypeQuery)query);
            if (this.location != null) {
                UserQueryFactory.addLocationConstraint((Party)this.location, (ArchetypeQuery)query);
            }
            return query;
        }
    }

    private static class ClinicianObjectSetQuery
    extends EntityObjectSetQuery {
        private final Party location;
        private final CheckBox allLocations;

        public ClinicianObjectSetQuery(String[] shortNames, Party location, Party practice) {
            super(shortNames);
            if (location != null && this.hasMultipleLocations(practice)) {
                this.location = location;
                this.allLocations = CheckBoxFactory.create();
                this.allLocations.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                    public void onAction(ActionEvent event) {
                        this.onQuery();
                    }
                });
            } else {
                this.location = null;
                this.allLocations = null;
            }
        }

        protected boolean hasMultipleLocations(Party practice) {
            if (practice != null) {
                IMObjectBean bean = this.getService().getBean((IMObject)practice);
                return bean.getTargetRefs("locations").size() > 1;
            }
            return false;
        }

        @Override
        protected void doLayout(Component container) {
            super.doLayout(container);
            if (this.allLocations != null) {
                container.add((Component)LabelFactory.create((String)"location.all"));
                container.add((Component)this.allLocations);
            }
        }

        @Override
        protected ResultSet<ObjectSet> createResultSet(SortConstraint[] sort) {
            return new ClinicianResultSet(this.getArchetypeConstraint(), this.getValue(), this.isIdentitySearch(), sort, this.getMaxResults(), this.isDistinct(), this.getLocation());
        }

        private Party getLocation() {
            Party result = null;
            if (this.allLocations != null && !this.allLocations.isSelected()) {
                result = this.location;
            }
            return result;
        }
    }
}

