/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.help;

import echopointng.LabelEx;
import echopointng.xhtml.XhtmlFragment;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import java.util.TimeZone;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Command;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.layout.RowLayoutData;
import nextapp.echo2.webcontainer.command.BrowserOpenWindowCommand;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.system.common.util.StringUtilities;
import org.openvpms.version.Version;
import org.openvpms.web.component.help.HelpTopics;
import org.openvpms.web.component.subscription.SubscriptionHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.error.ErrorHandler;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.util.StyleSheetHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpDialog
extends ModalDialog {
    private final HelpTopics topics;
    private final String features;
    private static final String PATH = "/org/openvpms/web/resource/image/openvpms.png";
    private static final String HOME = "http://www.openvpms.org";
    private static final Logger log = LoggerFactory.getLogger(HelpDialog.class);
    private static final int TIMEOUT = 30000;

    public HelpDialog(HelpTopics topics, String features) {
        this(null, null, null, topics, features);
    }

    protected HelpDialog(String topic, String topicURL, String parentURL, HelpTopics topics, String features) {
        super(Messages.get((String)"helpdialog.title"), "HelpDialog", OK);
        Component content;
        this.topics = topics;
        this.features = features;
        Label component = null;
        if (topic != null) {
            if (topicURL == null) {
                Label label = LabelFactory.create((boolean)true, (boolean)true);
                label.setStyleName("bold");
                label.setText(Messages.format((String)"helpdialog.nohelp.topic", (Object[])new Object[]{topic}));
                component = label;
            } else {
                StringBuilder content2 = new StringBuilder();
                content2.append("<div xmlns='http://www.w3.org/1999/xhtml'>");
                content2.append("<p>");
                content2.append(Messages.format((String)"helpdialog.nohelp.create", (Object[])new Object[]{topicURL}));
                content2.append("</p>");
                if (parentURL != null) {
                    content2.append("<p>");
                    content2.append(Messages.format((String)"helpdialog.nohelp.parent", (Object[])new Object[]{parentURL}));
                    content2.append("</p>");
                }
                content2.append("</div>");
                LabelEx label = new LabelEx(new XhtmlFragment(content2.toString()));
                label.setLineWrap(true);
                component = label;
            }
        }
        Component topicComponent = this.getTopics();
        if (component != null) {
            Grid hack = new Grid();
            hack.setStyleName("HelpDialog.content.size");
            Row container = RowFactory.create((Component[])new Component[]{component, hack});
            content = SplitPaneFactory.create((int)1, (String)"HelpDialog.content", (Component[])new Component[]{topicComponent, container});
        } else {
            content = topicComponent;
        }
        SplitPane footer = SplitPaneFactory.create((int)6, (String)"HelpDialog.footer", (Component[])new Component[]{ColumnFactory.create((String)"Inset", (Component[])new Component[]{this.getSubscription()}), content});
        SplitPane header = SplitPaneFactory.create((int)5, (String)"HelpDialog.header", (Component[])new Component[]{this.getHeader(), footer});
        this.getLayout().add((Component)header);
    }

    public static void show(HelpContext help, HelpTopics topics, String features) {
        if (help == null) {
            new HelpDialog(topics, features).show();
        } else {
            HelpDialog.show(help.getTopic(), topics, features);
        }
    }

    public static void show(String topic, HelpTopics topics, String features) {
        block9: {
            String url = HelpDialog.getTopicURL(topic, topics);
            if (url != null) {
                try {
                    Topic resource = new Topic(url);
                    if (resource.exists()) {
                        HelpDialog.openWindow(url, features);
                        break block9;
                    }
                    if (resource.notFound()) {
                        Topic parentResource = resource.findParent();
                        if (parentResource == null || parentResource.exists()) {
                            String parent = parentResource != null ? parentResource.getURL() : null;
                            HelpDialog dialog = new HelpDialog(topic, url, parent, topics, features);
                            dialog.show();
                        } else {
                            HelpDialog.showError(resource);
                        }
                        break block9;
                    }
                    if (resource.unavailable()) {
                        ErrorHelper.show(Messages.get((String)"helpdialog.title"), Messages.get((String)"helpdialog.unavailable"));
                        break block9;
                    }
                    HelpDialog.showError(resource);
                }
                catch (IOException exception) {
                    ErrorHelper.show(Messages.get((String)"helpdialog.title"), Messages.format((String)"helpdialog.error", (Object[])new Object[]{exception.getMessage()}));
                }
            } else {
                HelpDialog dialog = new HelpDialog(topic, null, null, topics, features);
                dialog.show();
            }
        }
    }

    public static HelpContext getHelpContext(String topic) {
        return new HelpContext(topic, help -> {
            String features = StyleSheetHelper.getProperty((String)"HelpBrowser.features");
            HelpDialog.show(help, ServiceHelper.getBean(HelpTopics.class), features);
        });
    }

    private static void showError(Topic resource) {
        if (log.isErrorEnabled()) {
            log.error("Failed to open help for URL=" + resource.getURL() + ", response=" + resource.getResponseCode());
        }
        String status = Messages.format((String)"helpdialog.errorstatus", (Object[])new Object[]{resource.getResponseCode()});
        String message = Messages.format((String)"helpdialog.error", (Object[])new Object[]{status});
        ErrorHandler.getInstance().error(Messages.get((String)"helpdialog.title"), message, null, null);
    }

    private Component getTopics() {
        String url;
        String topic;
        Column container = ColumnFactory.create((String)"WideCellSpacing");
        int i = 0;
        while ((topic = this.topics.get("help.topic." + i + ".title", true)) != null && (url = this.topics.get("help.topic." + i + ".url", true)) != null) {
            Button helpLink = this.createHelpURL(topic, url);
            container.add((Component)RowFactory.create((Component[])new Component[]{helpLink}));
            ++i;
        }
        return ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{container});
    }

    private Button createHelpURL(String topic, final String url) {
        Button helpLink = ButtonFactory.create(null, (String)"hyperlink");
        helpLink.setText(topic);
        helpLink.setBackground(null);
        helpLink.setToolTipText(url);
        helpLink.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent e) {
                HelpDialog.this.launch(url);
            }
        });
        return helpLink;
    }

    private Component getHeader() {
        Button logo = new Button((ImageReference)new ResourceImageReference(PATH));
        logo.setToolTipText(HOME);
        logo.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent e) {
                HelpDialog.this.launch(HelpDialog.HOME);
            }
        });
        RowLayoutData centre = new RowLayoutData();
        centre.setAlignment(new Alignment(0, 4));
        logo.setLayoutData((LayoutData)centre);
        Label version = LabelFactory.create(null, (String)"small");
        version.setText(Messages.format((String)"helpdialog.version", (Object[])new Object[]{Version.VERSION, Version.REVISION}));
        Label locale = LabelFactory.create(null, (String)"small");
        locale.setText(Messages.format((String)"helpdialog.locale", (Object[])new Object[]{Locale.getDefault().toLanguageTag(), TimeZone.getDefault().getID()}));
        Row labelRow = RowFactory.create((String)"InsetX", (Component[])new Component[]{RowFactory.create((String)"CellSpacing", (Component[])new Component[]{version, locale})});
        RowLayoutData right = new RowLayoutData();
        right.setAlignment(new Alignment(5, 7));
        right.setWidth(new Extent(100, 2));
        labelRow.setLayoutData((LayoutData)right);
        return RowFactory.create((String)"Inset", (Component[])new Component[]{logo, labelRow});
    }

    private void launch(String url) {
        HelpDialog.openWindow(url, this.features);
        this.close();
    }

    private static void openWindow(String url, String features) {
        ApplicationInstance.getActive().enqueueCommand((Command)new BrowserOpenWindowCommand(url, null, features));
    }

    private LabelEx getSubscription() {
        String subscription = SubscriptionHelper.formatSubscription();
        String content = "<p xmlns='http://www.w3.org/1999/xhtml'>" + subscription + "</p>";
        LabelEx label = new LabelEx(new XhtmlFragment(content));
        label.setLineWrap(true);
        label.setTextAlignment(Alignment.ALIGN_CENTER);
        return label;
    }

    private static String getTopicURL(String topic, HelpTopics topics) {
        String result = null;
        String baseURL = topics.getBaseURL();
        if (baseURL != null) {
            String fragment = topics.get(topic, true);
            if (fragment == null) {
                for (String key : topics.getKeys()) {
                    if (!StringUtilities.matches((String)topic, (String)key)) continue;
                    fragment = topics.get(key, true);
                    break;
                }
            }
            if (fragment != null) {
                result = baseURL + "/" + fragment;
            }
        }
        return result;
    }

    private static class Topic {
        private final String topicURL;
        private int responseCode;

        public Topic(String topicURL) throws IOException {
            this.topicURL = topicURL;
            URL url = new URL(topicURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            this.responseCode = connection.getResponseCode();
            connection.disconnect();
        }

        public String getURL() {
            return this.topicURL;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public boolean exists() {
            return this.responseCode >= 200 && this.responseCode < 400;
        }

        public boolean notFound() {
            return this.responseCode == 404;
        }

        public boolean unavailable() {
            return this.responseCode == 503;
        }

        public Topic findParent() throws IOException {
            Topic result = null;
            try {
                URI uri = new URI(this.topicURL);
                String path = uri.getPath();
                while (!StringUtils.isEmpty((CharSequence)path)) {
                    uri = !path.endsWith("/") ? uri.resolve(".") : uri.resolve("..");
                    String parentURL = uri.toURL().toString();
                    Topic parent = new Topic(parentURL);
                    if (parent.notFound()) {
                        path = uri.getPath();
                        continue;
                    }
                    result = parent;
                    break;
                }
            }
            catch (MalformedURLException | URISyntaxException exception) {
                log.debug(exception.getMessage(), (Throwable)exception);
            }
            return result;
        }
    }
}

