/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.error;

import java.io.PrintWriter;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ThrowableAdapter {
    private Class<?> type;
    private String message;
    private StackTraceElement[] stackTrace;
    private ThrowableAdapter cause;

    public ThrowableAdapter() {
    }

    public ThrowableAdapter(Throwable exception) {
        this.type = exception.getClass();
        this.message = exception.getLocalizedMessage();
        this.stackTrace = exception.getStackTrace();
        Throwable root = ExceptionUtils.getCause((Throwable)exception);
        if (root != null) {
            this.cause = new ThrowableAdapter(root);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public ThrowableAdapter getCause() {
        return this.cause;
    }

    public String toString() {
        String result = this.type.getName();
        return this.message != null ? result + ": " + this.message : result;
    }

    public void printStackTrace(PrintWriter writer) {
        writer.println(this);
        for (StackTraceElement trace : this.stackTrace) {
            writer.println("\tat " + trace);
        }
        if (this.cause != null) {
            this.cause.printStackTraceAsCause(writer, this.stackTrace);
        }
    }

    private void printStackTraceAsCause(PrintWriter writer, StackTraceElement[] causedTrace) {
        StackTraceElement[] trace = this.stackTrace;
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        writer.println("Caused by: " + this);
        for (int i = 0; i <= m; ++i) {
            writer.println("\tat " + trace[i]);
        }
        if (framesInCommon != 0) {
            writer.println("\t... " + framesInCommon + " more");
        }
        if (this.cause != null) {
            this.cause.printStackTraceAsCause(writer, trace);
        }
    }
}

