/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.error;

import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openvpms.component.exception.OpenVPMSException;

public class ExceptionConfig {
    private String className;
    private List<String> ids;
    private List<String> codes;
    private List<String> messages;
    private List<ExceptionConfig> causes;

    public ExceptionConfig() {
    }

    public ExceptionConfig(String className) {
        this.setClassName(className);
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public List<String> getIds() {
        return this.ids != null ? this.ids : Collections.emptyList();
    }

    public void setIds(List<String> ids) {
        this.ids = ids;
    }

    public void setCodes(List<String> codes) {
        this.codes = codes;
    }

    public List<String> getCodes() {
        return this.codes != null ? this.codes : Collections.emptyList();
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    public List<String> getMessages() {
        return this.messages != null ? this.messages : Collections.emptyList();
    }

    public void setCauses(List<ExceptionConfig> causes) {
        this.causes = causes;
    }

    public List<ExceptionConfig> getCauses() {
        return this.causes;
    }

    public boolean isExcluded(Throwable exception) {
        Object message;
        boolean eval = false;
        if (exception instanceof OpenVPMSException && this.ids != null && !this.ids.isEmpty() && this.ids.contains((message = ((OpenVPMSException)exception).getI18nMessage()).getId())) {
            return true;
        }
        if (this.codes != null && !this.codes.isEmpty()) {
            eval = true;
            try {
                String s = BeanUtils.getProperty((Object)exception, (String)"errorCode");
                if (this.codes.contains(s)) {
                    return true;
                }
            }
            catch (Throwable s) {
                // empty catch block
            }
        }
        if (this.messages != null && !this.messages.isEmpty()) {
            eval = true;
            message = exception.getMessage();
            if (message != null && this.messages.contains(message)) {
                return true;
            }
        }
        if (this.causes != null && !this.causes.isEmpty()) {
            eval = true;
            Throwable root = ExceptionUtils.getRootCause((Throwable)exception);
            if (root != null && root != exception) {
                for (ExceptionConfig cause : this.causes) {
                    if (!cause.isExcluded(root)) continue;
                    return true;
                }
            }
        }
        return !eval;
    }
}

