/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.error;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openvpms.component.system.common.xstream.XStreamFactory;
import org.openvpms.web.component.error.ExceptionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorReporterConfig {
    private List<ExceptionConfig> excludes;
    private transient Map<String, ExceptionConfig> excludesMap;
    private static final Logger log = LoggerFactory.getLogger(ErrorReporterConfig.class);

    public synchronized void setExcludes(List<ExceptionConfig> excludes) {
        this.excludes = excludes;
        this.excludesMap = null;
    }

    public synchronized List<ExceptionConfig> getExcludes() {
        return this.excludes;
    }

    public boolean isExcluded(Throwable exception) {
        Throwable cause;
        boolean result = false;
        Map<String, ExceptionConfig> map = this.getExcludesMap();
        ExceptionConfig config = null;
        Iterator iterator = ExceptionUtils.getThrowableList((Throwable)exception).iterator();
        while (iterator.hasNext() && (config = map.get((cause = (Throwable)iterator.next()).getClass().getName())) == null) {
        }
        if (config != null) {
            result = config.isExcluded(exception);
        }
        return result;
    }

    public synchronized void write(OutputStream stream) {
        XStream xs = ErrorReporterConfig.createStream();
        xs.toXML((Object)this, stream);
    }

    public static ErrorReporterConfig read(InputStream stream) {
        return (ErrorReporterConfig)ErrorReporterConfig.createStream().fromXML(stream);
    }

    private synchronized Map<String, ExceptionConfig> getExcludesMap() {
        if (this.excludesMap == null) {
            this.excludesMap = new HashMap<String, ExceptionConfig>();
            if (this.excludes != null) {
                for (ExceptionConfig exclude : this.excludes) {
                    ExceptionConfig old = this.excludesMap.put(exclude.getClassName(), exclude);
                    if (old != null) {
                        log.warn("Replacing existing exclusion for class: " + exclude.getClassName());
                    }
                    this.checkClass(exclude);
                }
            }
        }
        return this.excludesMap;
    }

    private void checkClass(ExceptionConfig config) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(config.getClassName());
        }
        catch (ClassNotFoundException exception) {
            log.warn("Class not found: " + config.getClassName());
        }
    }

    private static XStream createStream() {
        XStream xs = XStreamFactory.create((Class[])new Class[]{ErrorReporterConfig.class, ExceptionConfig.class});
        xs.alias("error-reporter-config", ErrorReporterConfig.class);
        xs.addImplicitCollection(ErrorReporterConfig.class, "excludes", "exclude-exception", ExceptionConfig.class);
        xs.addImplicitCollection(ExceptionConfig.class, "ids", "id", String.class);
        xs.addImplicitCollection(ExceptionConfig.class, "codes", "code", String.class);
        xs.addImplicitCollection(ExceptionConfig.class, "messages", "message", String.class);
        xs.addImplicitCollection(ExceptionConfig.class, "causes", "cause", ExceptionConfig.class);
        return xs;
    }
}

