/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.error;

import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Window;
import org.apache.commons.text.StringEscapeUtils;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.component.error.ErrorReportingDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.error.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogErrorHandler
extends ErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(DialogErrorHandler.class);

    public void error(Throwable cause) {
        String message = ErrorFormatter.formatHTML(cause);
        this.error(null, message, true, cause, null);
    }

    public void error(String title, String message, boolean html, Throwable cause, Runnable listener) {
        log.error(html ? StringEscapeUtils.unescapeHtml4((String)message) : message, cause);
        if (this.canDisplay() && !this.inError()) {
            ErrorDialogBuilder builder = cause != null && ErrorReportingDialog.canReportErrors() ? ErrorReportingDialog.newDialog().cause(cause) : ErrorDialog.newDialog();
            ((ErrorDialogBuilder)((ErrorDialogBuilder)builder.title(title)).message(message, html)).listener(listener);
            builder.show();
        } else if (listener != null) {
            listener.run();
        }
    }

    public boolean inError() {
        Window root = ApplicationInstance.getActive().getDefaultWindow();
        for (Component component : root.getContent().getComponents()) {
            if (!(component instanceof ErrorDialog)) continue;
            return true;
        }
        return false;
    }

    private boolean canDisplay() {
        ApplicationInstance instance = ApplicationInstance.getActive();
        return instance != null && instance.getDefaultWindow() != null;
    }
}

