/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.web.component.bound.BoundProperty;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.text.TextField;

public class SpinBox
extends Row
implements BoundProperty {
    private final int min;
    private final int max;
    private final int increment;
    private final Property value;
    private final FocusGroup group;
    private final ModifiableListener listener;

    public SpinBox(int min, int max) {
        this(SpinBox.createProperty(min), min, max, 1);
    }

    public SpinBox(Property property, int min, int max) {
        this(property, min, max, 1);
    }

    public SpinBox(Property property, int min, int max, int increment) {
        this.min = min;
        this.max = max;
        this.increment = increment;
        this.group = new FocusGroup("SpinBox");
        this.listener = new ModifiableListener(){

            @Override
            public void modified(Modifiable modifiable) {
                SpinBox.this.checkRange();
            }
        };
        this.value = property;
        this.checkRange();
        int columns = Integer.toString(max).length() + 2;
        TextField text = BoundTextComponentFactory.createNumeric(property, columns);
        text.setStyleName("edit");
        Button inc = ButtonFactory.create(null, (String)"SpinBox.increment");
        inc.setFocusTraversalParticipant(false);
        inc.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                SpinBox.this.increment();
            }
        });
        Button dec = ButtonFactory.create(null, (String)"SpinBox.decrement");
        dec.setFocusTraversalParticipant(false);
        dec.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                SpinBox.this.decrement();
            }
        });
        Column column = ColumnFactory.create((Component[])new Component[]{inc, dec});
        this.add((Component)text);
        this.add((Component)column);
        this.group.add((Component)text);
    }

    public void setValue(int newValue) {
        if (newValue < this.min) {
            newValue = this.min;
        }
        if (newValue > this.max) {
            newValue = this.max;
        }
        this.value.removeModifiableListener(this.listener);
        this.value.setValue(newValue);
        this.value.addModifiableListener(this.listener);
    }

    public int getValue() {
        return this.value.getInt(this.min);
    }

    public FocusGroup getFocusGroup() {
        return this.group;
    }

    @Override
    public Property getProperty() {
        return this.value;
    }

    private void increment() {
        if (this.value.getValue() == null) {
            this.setValue(this.min);
        } else {
            int value = this.getValue();
            if (value < this.max) {
                this.setValue(value + this.increment);
            }
        }
    }

    private void decrement() {
        int value = this.getValue();
        if (value > this.min) {
            this.setValue(value - this.increment);
        }
    }

    private void checkRange() {
        int value = this.getValue();
        if (value < this.min) {
            this.setValue(this.min);
        } else if (value > this.max) {
            this.setValue(this.max);
        }
    }

    private static Property createProperty(int initial) {
        return new SimpleProperty("value", initial, Integer.class);
    }
}

