/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ChangeListener;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.web.component.bound.Binder;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.event.ActionListener;

public class SelectFieldBinder
extends Binder {
    private final SelectField component;
    private final ChangeListener listener;
    private final ActionListener actionListener;

    public SelectFieldBinder(SelectField component, Property property) {
        super(property, false);
        this.component = component;
        this.listener = (ChangeListener & Serializable)e -> this.setProperty();
        this.actionListener = new ActionListener(){

            public void onAction(ActionEvent e) {
            }
        };
        int index = this.indexOf(property.getValue());
        component.setSelectedIndex(index);
        this.bind();
    }

    @Override
    public void setField() {
        Property property = this.getProperty();
        if (!property.isCollection()) {
            this.setFieldValue(property.getValue());
        } else {
            List<?> values = ((CollectionProperty)property).getValues();
            if (!values.isEmpty()) {
                this.setFieldValue(values.get(0));
            }
        }
    }

    @Override
    public void bind() {
        if (!this.isBound()) {
            super.bind();
            this.component.getSelectionModel().addChangeListener(this.listener);
            this.component.addActionListener((nextapp.echo2.app.event.ActionListener)this.actionListener);
        }
    }

    @Override
    public void unbind() {
        if (this.isBound()) {
            super.unbind();
            this.component.getSelectionModel().removeChangeListener(this.listener);
            this.component.removeActionListener((nextapp.echo2.app.event.ActionListener)this.actionListener);
        }
    }

    @Override
    protected boolean setProperty(Property property) {
        boolean result = false;
        if (!property.isCollection()) {
            result = super.setProperty(property);
        } else {
            CollectionProperty collection = (CollectionProperty)property;
            List<?> values = collection.getValues();
            if (this.component.getSelectedIndex() == -1) {
                if (!values.isEmpty()) {
                    for (Object value : values) {
                        collection.remove(value);
                    }
                    result = true;
                }
            } else {
                Object fieldValue = this.getFieldValue();
                if (!values.contains(fieldValue)) {
                    for (Object value : values) {
                        collection.remove(value);
                    }
                    if (fieldValue != null) {
                        collection.add(fieldValue);
                    }
                    result = true;
                }
            }
        }
        return result;
    }

    @Override
    protected Object getFieldValue() {
        return this.component.getSelectedItem();
    }

    @Override
    protected void setFieldValue(Object value) {
        int index = this.indexOf(value);
        if (index != -1 && this.component.getSelectedIndex() != index) {
            boolean bound = this.isBound();
            if (bound) {
                this.component.getSelectionModel().removeChangeListener(this.listener);
            }
            this.component.setSelectedIndex(index);
            if (bound) {
                this.component.getSelectionModel().addChangeListener(this.listener);
            }
        }
    }

    protected int indexOf(Object value) {
        int result = -1;
        ListModel model = this.component.getModel();
        for (int i = 0; i < model.size(); ++i) {
            if (!this.equals(value, model, i)) continue;
            result = i;
            break;
        }
        return result;
    }

    protected boolean equals(Object value, ListModel model, int index) {
        return Objects.equals(model.get(index), value);
    }
}

