/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.util.Objects;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.text.Document;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.archetype.AssertionDescriptor;
import org.openvpms.component.model.archetype.NamedProperty;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.security.crypto.PasswordEncryptor;
import org.openvpms.web.component.bound.Binder;
import org.openvpms.web.component.bound.BoundProperty;
import org.openvpms.web.component.bound.TextComponentBinder;
import org.openvpms.web.component.property.DelegatingProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.text.PasswordField;
import org.openvpms.web.echo.text.TextComponent;
import org.openvpms.web.echo.text.TextDocument;
import org.openvpms.web.system.ServiceHelper;
import org.springframework.security.crypto.password.PasswordEncoder;

public class BoundPasswordField
extends PasswordField
implements BoundProperty {
    public Binder binder;
    private final PasswordEncryptor encryptor = ServiceHelper.getBean(PasswordEncryptor.class);
    private final PasswordEncoder encoder = ServiceHelper.getBean(PasswordEncoder.class);
    private final boolean isHash;
    private final Property wrapper;
    private String placeholder;
    private String plainText;

    public BoundPasswordField(Property property) {
        this.setDocument((Document)new TextDocument());
        int columns = property.getMaxLength();
        if (columns > 20) {
            columns = 20;
        }
        if (columns <= 10) {
            this.setWidth(new Extent(columns, 64));
        } else {
            this.setWidth(new Extent(columns, 128));
        }
        this.isHash = this.isHash(property);
        String encrypted = property.getString();
        if (encrypted != null && encrypted.length() != 0) {
            this.placeholder = StringUtils.repeat((char)'x', (int)14);
        }
        this.wrapper = new DelegatingProperty(property){

            @Override
            public boolean setValue(Object value) {
                boolean result;
                String text = value != null ? value.toString() : null;
                BoundPasswordField.this.placeholder = text;
                BoundPasswordField.this.plainText = text;
                if (text != null) {
                    text = !BoundPasswordField.this.isHash ? BoundPasswordField.this.encryptor.encrypt(text) : BoundPasswordField.this.encoder.encode((CharSequence)text);
                    result = super.setValue(text);
                } else {
                    result = super.setValue(null);
                }
                return result;
            }

            @Override
            public Object getValue() {
                return BoundPasswordField.this.placeholder;
            }
        };
        this.binder = new TextComponentBinder((TextComponent)this, this.wrapper);
        if (!StringUtils.isEmpty((CharSequence)property.getDescription())) {
            this.setToolTipText(property.getDescription());
        }
    }

    public void init() {
        super.init();
        this.binder.bind();
    }

    public void dispose() {
        super.dispose();
        this.binder.unbind();
    }

    @Override
    public Property getProperty() {
        return this.wrapper;
    }

    public boolean matches(BoundPasswordField other) {
        return Objects.equals(this.plainText, other.plainText);
    }

    public String getPlainText() {
        return this.plainText;
    }

    private boolean isHash(Property property) {
        NamedProperty hash;
        AssertionDescriptor password;
        boolean isHash = false;
        NodeDescriptor descriptor = property.getDescriptor();
        if (descriptor != null && (password = descriptor.getAssertionDescriptor("password")) != null && (hash = password.getProperty("hash")) != null && "true".equalsIgnoreCase((String)hash.getValue())) {
            isHash = true;
        }
        return isHash;
    }
}

