/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import echopointng.DateField;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.web.component.bound.BoundProperty;
import org.openvpms.web.component.bound.DateBinder;
import org.openvpms.web.component.property.DatePropertyTransformer;
import org.openvpms.web.component.property.DefaultPropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.date.DateFieldImpl;

public class BoundDateField
extends DateFieldImpl
implements BoundProperty {
    public static final Date MIN_DATE = java.sql.Date.valueOf("1970-01-01");
    private final DateBinder binder;
    private boolean includeTimeForToday = true;

    public BoundDateField(Property property) {
        this.binder = this.createBinder(property);
        if (property.getTransformer() == null || property.getTransformer() instanceof DefaultPropertyTransformer) {
            Date maxDate = DateRules.getDate((Date)new Date(), (int)100, (DateUnits)DateUnits.YEARS);
            property.setTransformer(new DatePropertyTransformer(property, MIN_DATE, maxDate));
        }
        if (!StringUtils.isEmpty((CharSequence)property.getDescription())) {
            this.setToolTipText(property.getDescription());
        }
        this.setAllowNulls(!property.isRequired());
    }

    public void setIncludeTimeForToday(boolean include) {
        this.includeTimeForToday = include;
    }

    public Date getMinDate() {
        Date result = null;
        Property property = this.binder.getProperty();
        if (property.getTransformer() instanceof DatePropertyTransformer) {
            DatePropertyTransformer transformer = (DatePropertyTransformer)property.getTransformer();
            result = transformer.getMinDate();
        }
        return result;
    }

    public Date getMaxDate() {
        Date result = null;
        Property property = this.binder.getProperty();
        if (property.getTransformer() instanceof DatePropertyTransformer) {
            DatePropertyTransformer transformer = (DatePropertyTransformer)property.getTransformer();
            result = transformer.getMaxDate();
        }
        return result;
    }

    public void setDate(Date date) {
        this.binder.getProperty().setValue(date);
    }

    public void init() {
        super.init();
        this.binder.bind();
    }

    public void dispose() {
        super.dispose();
        this.binder.unbind();
    }

    @Override
    public Property getProperty() {
        return this.binder.getProperty();
    }

    protected DateBinder createBinder(Property property) {
        return new DateBinder((DateField)this, property){

            @Override
            protected Date getFieldValue() {
                Date result = super.getFieldValue();
                if (result != null) {
                    Date current = (Date)this.getProperty().getValue();
                    if (current != null && DateRules.getDate((Date)current).equals(DateRules.getDate((Date)result))) {
                        result = current;
                    } else if (BoundDateField.this.includeTimeForToday) {
                        result = BoundDateField.this.getDatetimeIfToday(result);
                    }
                }
                return result;
            }
        };
    }

    protected DateBinder getBinder() {
        return this.binder;
    }

    private Date getDatetimeIfToday(Date date) {
        Calendar now = Calendar.getInstance();
        Calendar d = Calendar.getInstance();
        d.setTime(date);
        if (now.get(6) == d.get(6) && now.get(1) == d.get(1)) {
            return now.getTime();
        }
        return date;
    }
}

