/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.util.Objects;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;

public abstract class Binder {
    private final Property property;
    private final ModifiableListener listener;
    private boolean hasListener = false;
    private boolean bound = false;

    public Binder(Property property) {
        this(property, true);
    }

    public Binder(Property property, boolean bind) {
        this.property = property;
        this.listener = new ModifiableListener(){

            @Override
            public void modified(Modifiable modifiable) {
                Binder.this.setField();
            }
        };
        if (bind) {
            this.bind();
        }
    }

    public void setProperty() {
        boolean listener = this.hasListener;
        if (listener) {
            this.removeModifiableListener();
        }
        try {
            this.setProperty(this.property);
        }
        finally {
            if (listener) {
                this.addModifiableListener();
            }
        }
    }

    public void setField() {
        this.setFieldValue(this.property.getValue());
    }

    public void bind() {
        if (!this.bound) {
            this.setField();
            this.addModifiableListener();
            this.bound = true;
        }
    }

    public void unbind() {
        if (this.bound) {
            this.removeModifiableListener();
            this.bound = false;
        }
    }

    public Property getProperty() {
        return this.property;
    }

    protected boolean setProperty(Property property) {
        Object propertyValue;
        Object fieldValue = this.getFieldValue();
        boolean result = property.setValue(fieldValue);
        if (result && !Objects.equals(fieldValue, propertyValue = property.getValue())) {
            this.setField();
        }
        return result;
    }

    protected abstract Object getFieldValue();

    protected abstract void setFieldValue(Object var1);

    protected boolean isBound() {
        return this.bound;
    }

    private void addModifiableListener() {
        this.property.addModifiableListener(this.listener, 0);
        this.hasListener = true;
    }

    private void removeModifiableListener() {
        this.property.removeModifiableListener(this.listener);
        this.hasListener = false;
    }
}

