/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.app;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.util.IMObjectHelper;

public class SelectionHistory {
    public static final int DEFAULT_CAPACITY = 25;
    private final int capacity;
    private final Context context;
    private final List<Selection> selections = new ArrayList<Selection>();

    public SelectionHistory(Context context) {
        this(25, context);
    }

    public SelectionHistory(int capacity, Context context) {
        this.capacity = capacity;
        this.context = context;
    }

    public void add(IMObject object) {
        Reference ref = object.getObjectReference();
        Selection selection = new Selection(ref, this.context);
        this.selections.remove(selection);
        this.selections.add(0, selection);
        if (this.selections.size() > this.capacity) {
            this.selections.remove(this.selections.size() - 1);
        }
    }

    public List<Selection> getSelections() {
        return this.selections;
    }

    public Date getSelected(IMObject object) {
        return this.getSelected(object.getObjectReference());
    }

    public Date getSelected(Reference reference) {
        int index = this.selections.indexOf(new Selection(reference, this.context));
        return index != -1 ? this.selections.get(index).getTime() : null;
    }

    public static class Selection {
        private final Reference reference;
        private final Date time;
        private final Context context;

        public Selection(Reference reference, Context context) {
            this(reference, new Date(), context);
        }

        protected Selection(Reference reference, Date time, Context context) {
            this.reference = reference;
            this.time = time;
            this.context = context;
        }

        public Reference getReference() {
            return this.reference;
        }

        public IMObject getObject() {
            return IMObjectHelper.getObject(this.reference, this.context);
        }

        public Date getTime() {
            return this.time;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Selection && ((Selection)obj).reference.equals((Object)this.reference);
        }

        public int hashCode() {
            return this.reference.hashCode();
        }
    }
}

