/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.app;

import java.util.Date;
import java.util.HashMap;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ObjectRefSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.SelectionHistory;
import org.openvpms.web.component.prefs.UserPreferences;

public class PreferenceSelectionHistory
extends SelectionHistory {
    private final String shortName;
    private final UserPreferences preferences;
    private final String group;
    private final String name;

    public PreferenceSelectionHistory(Context context, String shortName, UserPreferences preferences, String group, String name) {
        super(context);
        this.shortName = shortName;
        this.preferences = preferences;
        this.group = group;
        this.name = name;
        this.parseHistory(context);
    }

    public String getShortName() {
        return this.shortName;
    }

    @Override
    public void add(IMObject object) {
        super.add(object);
        this.saveHistory();
    }

    protected void parseHistory(Context context) {
        Date time;
        String value = this.preferences.getString(this.group, this.name, null);
        String[] values = value != null ? value.split(",") : new String[]{};
        HashMap<Long, Date> map = new HashMap<Long, Date>();
        for (int i = 0; i < values.length - 1; i += 2) {
            long id;
            try {
                id = Long.valueOf(values[i]);
            }
            catch (NumberFormatException exception) {
                break;
            }
            try {
                time = new Date(Long.valueOf(values[i + 1]));
            }
            catch (NumberFormatException exception) {
                break;
            }
            map.put(id, time);
        }
        if (!map.isEmpty()) {
            ArchetypeQuery query = new ArchetypeQuery(this.shortName, true, false);
            query.getArchetypeConstraint().setAlias("p");
            query.add((IConstraint)new ObjectRefSelectConstraint("p"));
            query.add((IConstraint)Constraints.in((String)"id", (Object[])map.keySet().toArray()));
            ObjectSetQueryIterator iterator = new ObjectSetQueryIterator((IArchetypeQuery)query);
            while (iterator.hasNext()) {
                IMObjectReference ref = ((ObjectSet)iterator.next()).getReference("p.reference");
                time = (Date)map.get(ref.getId());
                this.getSelections().add(new SelectionHistory.Selection((Reference)ref, time, context));
            }
        }
    }

    protected void saveHistory() {
        StringBuilder builder = new StringBuilder();
        for (SelectionHistory.Selection selection : this.getSelections()) {
            String id = Long.toString(selection.getReference().getId());
            String time = Long.toString(selection.getTime().getTime());
            int length = id.length() + time.length() + 1;
            if (builder.length() > 0) {
                ++length;
            }
            if (builder.length() + length > 5000) break;
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(id).append(',').append(time);
        }
        this.preferences.setPreference(this.group, this.name, builder.toString(), true);
    }
}

