/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.app;

import java.util.function.Consumer;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.ContextListener;
import org.openvpms.web.component.app.GlobalContext;

public class LocationMonitor {
    private final GlobalContext context;
    private final ContextListener listener;
    private long id;
    private boolean registered;

    public LocationMonitor(GlobalContext context, Consumer<Party> callback) {
        this.context = context;
        this.id = this.getLocationId();
        this.listener = callback != null ? (key, value) -> callback.accept((Party)value) : null;
    }

    public void register() {
        if (!this.registered) {
            this.context.addListener("party.organisationLocation", this.listener);
            this.registered = true;
        }
    }

    public void unregister() {
        if (this.registered) {
            this.context.removeListener(this.listener);
            this.registered = false;
        }
    }

    public boolean changed() {
        long current = this.id;
        this.id = this.getLocationId();
        return current != this.id;
    }

    public Party getLocation() {
        return this.context.getLocation();
    }

    private long getLocationId() {
        Party location = this.getLocation();
        return location != null ? location.getId() : -1L;
    }
}

