/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.app;

import java.util.List;
import org.openvpms.archetype.rules.party.ContactMatcher;
import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.archetype.rules.party.PurposeMatcher;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.web.component.app.AbstractMailContext;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ReloadingContext;
import org.openvpms.web.component.im.contact.ContactHelper;
import org.openvpms.web.component.macro.MacroVariables;
import org.openvpms.web.system.ServiceHelper;

public abstract class ContextMailContext
extends AbstractMailContext {
    private final ArchetypeService service;
    private final Context context;
    private final String fromPurpose;
    private Variables variables;

    public ContextMailContext(Context context) {
        this(context, null);
    }

    public ContextMailContext(Context context, String fromPurpose) {
        this.context = context;
        this.fromPurpose = fromPurpose;
        this.service = ServiceHelper.getArchetypeService();
    }

    @Override
    public List<Contact> getFromAddresses() {
        int index;
        PurposeMatcher matcher;
        Contact match;
        List<Contact> result = ContactHelper.getEmailContacts(this.context.getLocation(), this.service);
        if (result.isEmpty()) {
            result = ContactHelper.getEmailContacts(this.context.getPractice(), this.service);
        }
        if (this.fromPurpose != null && !result.isEmpty() && (match = Contacts.find(result, (ContactMatcher)(matcher = new PurposeMatcher("contact.email", this.fromPurpose, (IMObjectBeanFactory)this.service)))) != null && (index = result.indexOf(match)) > 0) {
            result.remove(index);
            result.add(0, match);
        }
        return result;
    }

    @Override
    public Variables getVariables() {
        if (this.variables == null) {
            this.variables = new MacroVariables(new ReloadingContext(this.context), this.service, ServiceHelper.getLookupService());
        }
        return this.variables;
    }

    protected Context getContext() {
        return this.context;
    }

    protected ArchetypeService getService() {
        return this.service;
    }
}

