/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.alert;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.component.alert.Alerts;
import org.openvpms.web.component.alert.CustomerAlerts;
import org.openvpms.web.component.alert.PatientAlerts;
import org.openvpms.web.component.prefs.UserPreferences;

public class AlertManager {
    private final Alerts customerAlerts;
    private final Alerts patientAlerts;

    public AlertManager(UserPreferences preferences, LookupService lookups, CustomerRules customerRules, IArchetypeService service) {
        this.customerAlerts = new CustomerAlerts(preferences, lookups, customerRules, service);
        this.patientAlerts = new PatientAlerts(preferences, service);
    }

    public List<Alert> getAlerts(Party party) {
        List<Alert> result = party.isA("party.customerperson") ? this.customerAlerts.getAlerts(party) : (party.isA("party.patientpet") ? this.patientAlerts.getAlerts(party) : Collections.emptyList());
        return result;
    }

    public List<Alert> getMandatoryAlerts(Party party) {
        List<Alert> alerts = this.getAlerts(party);
        return alerts.stream().filter(alert -> alert.isMandatory() && !this.isAcknowledged((Alert)alert)).collect(Collectors.toList());
    }

    public void acknowledge(Alert alert) {
        this.getAlerts(alert).acknowledge(alert);
    }

    public boolean isAcknowledged(Alert alert) {
        return this.getAlerts(alert).isAcknowledged(alert);
    }

    private Alerts getAlerts(Alert alert) {
        return this.isPatientAlert(alert) ? this.patientAlerts : this.customerAlerts;
    }

    private boolean isPatientAlert(Alert alert) {
        return alert.getAlertType().isA("entity.patientAlertType");
    }
}

