/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.alert;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import org.openvpms.archetype.rules.finance.account.AccountType;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.echo.text.TextComponent;
import org.openvpms.web.resource.i18n.Messages;

public class ActiveAlertLayoutStrategy
extends AbstractLayoutStrategy {
    private final AccountType accountType;

    public ActiveAlertLayoutStrategy() {
        this((AccountType)null);
    }

    public ActiveAlertLayoutStrategy(AccountType accountType) {
        this.accountType = accountType;
    }

    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        Property notes;
        Property reason = properties.get("reason");
        if (reason != null) {
            ComponentState component = this.createComponent(reason, object, context);
            if (component.getComponent() instanceof TextComponent) {
                ((TextComponent)component.getComponent()).setWidth(new Extent(80, 128));
            }
            this.addComponent(component);
        }
        if ((notes = properties.get("notes")) != null) {
            this.addComponent(this.createComponent(notes, null, new Extent(15, 64), object, context));
        }
        return super.apply(object, properties, parent, context);
    }

    @Override
    protected ArchetypeNodes getArchetypeNodes(IMObject object, LayoutContext context) {
        ArchetypeNodes nodes = ArchetypeNodes.allSimple().exclude("status").excludeIfEmpty("startTime", "endTime", "reason", "product", "clinician", "notes");
        String node = object.isA("act.patientAlert") ? "patient" : "customer";
        nodes.simple(node).first(node);
        return nodes;
    }

    @Override
    protected ComponentGrid createGrid(IMObject object, List<Property> properties, LayoutContext context) {
        ComponentGrid grid = this.createGrid(object, properties, context, 1);
        if (this.accountType != null) {
            Label label = LabelFactory.create();
            label.setText(Messages.format((String)"alert.accounttype", (Object[])new Object[]{this.accountType.getName()}));
            grid.add(new Component[]{TableHelper.createSpacer()});
            grid.add((Component)label, 2);
        }
        return grid;
    }
}

