/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.action;

import java.util.function.Supplier;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ObjectSupplier;

class ReloadingObjectSupplier<T extends IMObject>
implements ObjectSupplier<T> {
    private final String archetype;
    private final ArchetypeService service;
    private final Supplier<T> supplier;
    private boolean first;

    public ReloadingObjectSupplier(String archetype, ArchetypeService service, Supplier<T> supplier, boolean reloadOnFirst) {
        this.archetype = archetype;
        this.service = service;
        this.supplier = supplier;
        this.first = !reloadOnFirst;
    }

    @Override
    public T get() {
        IMObject result = (IMObject)this.supplier.get();
        if (this.first) {
            this.first = false;
        } else if (result != null) {
            result = this.service.get(result.getObjectReference(), result.getClass());
        }
        return (T)result;
    }

    @Override
    public String getArchetype() {
        return this.archetype;
    }
}

