/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.action;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionStatus;
import org.openvpms.web.component.action.Behaviour;
import org.openvpms.web.component.action.ReloadingAction;
import org.openvpms.web.resource.i18n.Messages;
import org.springframework.transaction.PlatformTransactionManager;

class IMObjectsConsumerAction<T extends IMObject>
extends ReloadingAction {
    private final List<T> objects;
    private final BiConsumer<List<T>, Consumer<ActionStatus>> consumer;

    public IMObjectsConsumerAction(List<T> objects, Behaviour behaviour, boolean async, BiConsumer<List<T>, Consumer<ActionStatus>> consumer, ArchetypeService service, PlatformTransactionManager transactionManager) {
        super(behaviour, async, service, transactionManager);
        this.objects = objects;
        this.consumer = consumer;
        for (IMObject object : objects) {
            this.addObject(object);
        }
    }

    @Override
    protected void execute(Consumer<ActionStatus> listener) {
        ActionStatus result = null;
        ArrayList<IMObject> latest = new ArrayList<IMObject>();
        for (IMObject object : this.objects) {
            IMObject current = this.getCurrentObject(object);
            if (current == null) {
                result = ActionStatus.failed(Messages.get((String)"action.internalerror"));
                continue;
            }
            latest.add(current);
        }
        if (result == null) {
            this.consumer.accept(latest, listener);
        } else {
            listener.accept(result);
        }
    }
}

