/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.action;

import org.openvpms.web.component.action.FailureReason;

public class ActionStatus {
    private final Status status;
    private final FailureReason reason;
    private boolean notified;

    private ActionStatus(Status status) {
        this(status, null);
    }

    private ActionStatus(Status status, FailureReason reason) {
        this.status = status;
        this.reason = reason;
    }

    public boolean succeeded() {
        return this.status == Status.SUCCESS;
    }

    public boolean skipped() {
        return this.status == Status.SKIPPED;
    }

    public boolean failed() {
        return this.status == Status.FAILED;
    }

    public boolean canRetry() {
        return this.status == Status.RETRY;
    }

    public String getMessage() {
        return this.reason != null ? this.reason.getMessage() : null;
    }

    public Throwable getException() {
        return this.reason != null ? this.reason.getException() : null;
    }

    public boolean notified() {
        return this.notified;
    }

    public void setNotified() {
        this.notified = true;
    }

    public FailureReason getReason() {
        return this.reason;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("status=").append((Object)this.status);
        if (this.reason != null) {
            result.append(",reason=").append(this.reason);
        }
        return result.toString();
    }

    public static ActionStatus skipped(FailureReason reason) {
        return new ActionStatus(Status.SKIPPED, reason);
    }

    public static ActionStatus success() {
        return new ActionStatus(Status.SUCCESS);
    }

    public static ActionStatus retry(Throwable exception) {
        return ActionStatus.retry(FailureReason.exception(exception));
    }

    public static ActionStatus retry(FailureReason reason) {
        return new ActionStatus(Status.RETRY, reason);
    }

    public static ActionStatus failed(String message) {
        return ActionStatus.failed(FailureReason.error(message));
    }

    public static ActionStatus failed(Throwable exception) {
        return ActionStatus.failed(FailureReason.exception(exception));
    }

    public static ActionStatus failed(FailureReason reason) {
        return new ActionStatus(Status.FAILED, reason);
    }

    public static ActionStatus failed(ActionStatus status) {
        return new ActionStatus(Status.FAILED, status.getReason());
    }

    static enum Status {
        SUCCESS,
        SKIPPED,
        RETRY,
        FAILED;

    }
}

