/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.action;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import nextapp.echo2.app.ApplicationInstance;
import org.apache.commons.lang3.RandomUtils;
import org.openvpms.web.component.action.Action;
import org.openvpms.web.component.action.ActionBuilder;
import org.openvpms.web.component.action.ActionStatus;
import org.openvpms.web.component.action.AsynchronousAction;
import org.openvpms.web.component.action.DefaultActionStatusConsumer;
import org.openvpms.web.component.action.FailureAction;
import org.openvpms.web.component.action.Retries;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ActionRunner
extends AsynchronousAction {
    protected static final String RETRY_ID = "button.retry";
    private final long id = seed.getAndIncrement();
    private final Action action;
    private final Action successAction;
    private final Action skipAction;
    private final FailureAction failureAction;
    private final boolean interactive;
    private final Retries retries;
    private int attempts;
    private static final AtomicLong seed = new AtomicLong();
    private static final Logger log = LoggerFactory.getLogger(ActionRunner.class);

    public ActionRunner(Action action, Action successAction, Action skipAction, FailureAction failureAction, boolean interactive, Retries retries) {
        this.action = action;
        this.successAction = successAction;
        this.skipAction = skipAction;
        this.failureAction = failureAction;
        this.interactive = interactive;
        this.retries = retries;
    }

    @Override
    public void run() {
        this.run(new DefaultActionStatusConsumer(this.interactive));
    }

    @Override
    public void run(Consumer<ActionStatus> listener) {
        this.attempts = 0;
        super.run(listener);
    }

    @Override
    protected void runAction(Consumer<ActionStatus> listener) {
        ++this.attempts;
        try {
            this.action.run(status -> {
                if (status.succeeded()) {
                    this.runSuccess(listener);
                } else if (status.canRetry()) {
                    this.retry((ActionStatus)status, listener);
                } else if (status.skipped()) {
                    this.runSkipped((ActionStatus)status, listener);
                } else {
                    this.runFailed((ActionStatus)status, listener);
                }
            });
        }
        catch (Throwable exception) {
            this.retry(ActionStatus.retry(exception), listener);
        }
    }

    protected void delay() {
        long delay = this.interactive ? RandomUtils.nextLong((long)0L, (long)1000L) : (long)(this.attempts * this.attempts) * this.retries.delay();
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }

    private void retry(ActionStatus status, Consumer<ActionStatus> listener) {
        if (this.retries.automaticRetry()) {
            this.log("Retrying failed action", status, false);
            if (this.attempts > 1 || this.retries.delayFirst()) {
                this.delay();
            }
            this.runAction(listener);
        } else if (this.retries.interactiveRetry() && this.canShowDialog()) {
            status.setNotified();
            ((ErrorDialogBuilder)((ErrorDialogBuilder)ActionBuilder.newErrorDialog(status).button(RETRY_ID, () -> {
                this.log("Retrying failed action", status, false);
                this.runProtected(listener);
            })).cancel(() -> this.runFailed(ActionStatus.failed(status), listener))).show();
        } else {
            this.runFailed(ActionStatus.failed(status), listener);
        }
    }

    private void runSuccess(Consumer<ActionStatus> listener) {
        if (this.successAction != null) {
            try {
                this.successAction.run(listener);
            }
            catch (Throwable exception) {
                listener.accept(ActionStatus.failed(exception));
            }
        } else {
            listener.accept(ActionStatus.success());
        }
    }

    private void runSkipped(ActionStatus status, Consumer<ActionStatus> listener) {
        this.log("Skipping failed action", status, true);
        if (!this.interactive) {
            status.setNotified();
        }
        if (this.skipAction != null) {
            try {
                this.skipAction.run(subStatus -> {
                    if (subStatus.failed()) {
                        this.log("Skip action failed", (ActionStatus)subStatus, true);
                    }
                    listener.accept(status);
                });
            }
            catch (Throwable exception) {
                log.error("Error running skip action: {}", (Object)exception.getMessage(), (Object)exception);
                listener.accept(status);
            }
        } else {
            listener.accept(status);
        }
    }

    private void runFailed(ActionStatus status, Consumer<ActionStatus> listener) {
        this.log("Action failed", status, true);
        if (!this.interactive) {
            status.setNotified();
        }
        if (this.failureAction != null) {
            try {
                this.failureAction.run(status, () -> listener.accept(status));
            }
            catch (Throwable exception) {
                log.error("Error running failure action: {}", (Object)exception.getMessage(), (Object)exception);
                listener.accept(status);
            }
        } else {
            listener.accept(status);
        }
    }

    private boolean canShowDialog() {
        return this.interactive && ApplicationInstance.getActive() != null;
    }

    private void log(String message, ActionStatus status, boolean error) {
        if (status.getException() != null) {
            if (error) {
                log.error("{}, id={}, attempts={}, status: {}", new Object[]{message, this.id, this.attempts, status, status.getException()});
            } else {
                log.debug("{}, id={}, attempts={}, status: {}", new Object[]{message, this.id, this.attempts, status, status.getException()});
            }
        } else if (error) {
            log.error("{}, id={}, attempts={}, status: {}", new Object[]{message, this.id, this.attempts, status});
        } else {
            log.debug("{}, id={}, attempts={}, status: {}", new Object[]{message, this.id, this.attempts, status});
        }
    }
}

