/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.function.factory.ArchetypeFunctionsFactory;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.lookup.TestMacroBuilder;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.macro.Macros;
import org.openvpms.macro.impl.LookupMacros;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.property.IMObjectProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyException;
import org.openvpms.web.component.property.PropertyTestHelper;
import org.openvpms.web.component.property.StringPropertyTransformer;
import org.springframework.beans.factory.annotation.Autowired;

public class StringPropertyTransformerTestCase
extends ArchetypeServiceTest {
    @Autowired
    private ArchetypeFunctionsFactory functions;
    @Autowired
    private ReportFactory reportFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestLookupFactory lookupFactory;

    @Test
    public void testApply() {
        Party person = (Party)this.customerFactory.newCustomer().build(false);
        NodeDescriptor descriptor = PropertyTestHelper.getDescriptor((IMObject)person, "name");
        IMObjectProperty property = new IMObjectProperty((IMObject)person, (org.openvpms.component.model.archetype.NodeDescriptor)descriptor);
        StringPropertyTransformer handler = new StringPropertyTransformer((Property)property);
        Assert.assertNull((Object)handler.apply(null));
        Assert.assertNull((Object)handler.apply((Object)""));
        Assert.assertEquals((Object)"abc", (Object)handler.apply((Object)"abc"));
        Assert.assertEquals((Object)"1", (Object)handler.apply((Object)1));
    }

    @Test
    public void testExceptionForControlChars() {
        String bad = "abcd\u000012345";
        Party person = (Party)this.customerFactory.newCustomer().build(false);
        NodeDescriptor descriptor = PropertyTestHelper.getDescriptor((IMObject)person, "name");
        IMObjectProperty property = new IMObjectProperty((IMObject)person, (org.openvpms.component.model.archetype.NodeDescriptor)descriptor);
        StringPropertyTransformer handler = new StringPropertyTransformer((Property)property);
        try {
            handler.apply((Object)bad);
            Assert.fail((String)"Expected PropertyException to be thrown");
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
    }

    @Test
    public void testMacroExpansion() {
        Party person = (Party)this.customerFactory.newCustomer().build(false);
        NodeDescriptor descriptor = PropertyTestHelper.getDescriptor((IMObject)person, "lastName");
        IMObjectProperty property = new IMObjectProperty((IMObject)person, (org.openvpms.component.model.archetype.NodeDescriptor)descriptor);
        LookupMacros macros = new LookupMacros(this.getLookupService(), this.getArchetypeService(), this.reportFactory, this.functions);
        StringPropertyTransformer handler = new StringPropertyTransformer((Property)property, (Macros)macros);
        Object text1 = handler.apply((Object)"macro1");
        Assert.assertEquals((Object)"macro 1 text", (Object)text1);
        Object text2 = handler.apply((Object)"macro2");
        Assert.assertEquals((Object)"onetwothree", (Object)text2);
        Object text3 = handler.apply((Object)"macro1 macro2");
        Assert.assertEquals((Object)"macro 1 text onetwothree", (Object)text3);
        Object text4 = handler.apply((Object)"displayName");
        Assert.assertEquals((Object)"Customer", (Object)text4);
        Object text5 = handler.apply((Object)"invalidNode");
        Assert.assertEquals((Object)"invalidNode", (Object)text5);
        Object text6 = handler.apply((Object)"non existent");
        Assert.assertEquals((Object)"non existent", (Object)text6);
        macros.destroy();
    }

    @Test
    public void testUnsupportedChar() {
        String bad1 = "\ud83d\ude00";
        Party person = (Party)this.customerFactory.newCustomer().build(false);
        NodeDescriptor descriptor = PropertyTestHelper.getDescriptor((IMObject)person, "name");
        IMObjectProperty property = new IMObjectProperty((IMObject)person, (org.openvpms.component.model.archetype.NodeDescriptor)descriptor);
        StringPropertyTransformer handler = new StringPropertyTransformer((Property)property);
        try {
            handler.apply((Object)bad1);
            Assert.fail((String)"Expected PropertyException to be thrown");
        }
        catch (PropertyException expected) {
            Assert.assertEquals((Object)"Name contains an unsupported character: \ud83d\ude00", (Object)expected.getMessage());
        }
        String bad2 = "\ud83d";
        try {
            handler.apply((Object)bad2);
            Assert.fail((String)"Expected PropertyException to be thrown");
        }
        catch (PropertyException expected) {
            Assert.assertEquals((Object)"Name contains an unsupported character: \ud83d", (Object)expected.getMessage());
        }
    }

    @Before
    public void setUp() {
        this.createMacro("macro1", "'macro 1 text'");
        this.createMacro("macro2", "concat('one', 'two', 'three')");
        this.createMacro("displayName", "openvpms:get(., 'displayName')");
        this.createMacro("exceptionMacro", "openvpms:get(., 'invalidnode')");
        this.createMacro("nested", "concat('nested test: ', $macro1)");
        this.createMacro("numbertest", "concat('input number: ', $number)");
    }

    private void createMacro(String code, String expression) {
        ((TestMacroBuilder)((TestMacroBuilder)this.lookupFactory.newMacro().code(code)).name(code)).expression(expression).build();
    }
}

