/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionTypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.datatypes.property.AssertionProperty;
import org.openvpms.component.business.domain.im.datatypes.property.PropertyList;
import org.openvpms.component.business.domain.im.datatypes.property.PropertyMap;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.archetype.AssertionDescriptor;
import org.openvpms.component.model.archetype.NamedProperty;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.property.AbstractPropertyTest;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.IMObjectProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyTestHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;

public class IMObjectPropertyTestCase
extends AbstractPropertyTest {
    @Test
    public void testGetObject() {
        org.openvpms.component.model.object.IMObject object = this.createIMObject();
        IMObjectProperty property = new IMObjectProperty(object, this.createDescriptor());
        Assert.assertSame((Object)property.getObject(), (Object)object);
    }

    @Override
    @Test
    public void testGetDescriptor() {
        org.openvpms.component.model.archetype.NodeDescriptor descriptor = this.createDescriptor();
        IMObjectProperty property = new IMObjectProperty(this.createIMObject(), descriptor);
        Assert.assertSame((Object)property.getDescriptor(), (Object)descriptor);
    }

    @Override
    @Test
    public void testDisplayName() {
        org.openvpms.component.model.archetype.NodeDescriptor descriptor = this.createDescriptor();
        descriptor.setDisplayName("foo");
        IMObjectProperty property = new IMObjectProperty(this.createIMObject(), descriptor);
        Assert.assertEquals((Object)"foo", (Object)property.getDisplayName());
    }

    @Override
    @Test
    public void testDescription() {
        org.openvpms.component.model.archetype.NodeDescriptor descriptor = this.createDescriptor();
        descriptor.setDescription("foo");
        IMObjectProperty property = new IMObjectProperty(this.createIMObject(), descriptor);
        Assert.assertEquals((Object)"foo", (Object)property.getDescription());
    }

    @Override
    @Test
    public void testIsLookup() {
        org.openvpms.component.model.archetype.NodeDescriptor descriptor = this.createDescriptor();
        descriptor.setType(String.class.getName());
        IMObjectProperty property = new IMObjectProperty(this.createIMObject(), descriptor);
        Assert.assertFalse((boolean)property.isLookup());
        org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor lookup = new org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor();
        lookup.setName("lookup");
        descriptor.addAssertionDescriptor((AssertionDescriptor)lookup);
        Assert.assertTrue((boolean)property.isLookup());
    }

    @Override
    @Test
    public void testIsCollection() {
        org.openvpms.component.model.archetype.NodeDescriptor descriptor = this.createDescriptor();
        descriptor.setType(String.class.getName());
        IMObjectProperty property = new IMObjectProperty(this.createIMObject(), descriptor);
        Assert.assertFalse((boolean)property.isCollection());
        descriptor.setType(HashMap.class.getName());
        Assert.assertTrue((boolean)property.isCollection());
        descriptor.setType(ArrayList.class.getName());
        Assert.assertTrue((boolean)property.isCollection());
        descriptor.setType(HashSet.class.getName());
        Assert.assertTrue((boolean)property.isCollection());
    }

    @Override
    @Test
    public void testGetArchetypeRange() {
        org.openvpms.component.model.archetype.NodeDescriptor descriptor = this.createDescriptor();
        IMObjectProperty property = new IMObjectProperty(this.createIMObject(), descriptor);
        Assert.assertEquals((long)0L, (long)property.getArchetypeRange().length);
        this.addArchetypeRange(descriptor, "party.patientpet");
        Assert.assertEquals((long)1L, (long)property.getArchetypeRange().length);
        Assert.assertEquals((Object)"party.patientpet", (Object)property.getArchetypeRange()[0]);
        this.addArchetypeRange(descriptor, "act.customerAccountCharges*");
        List<String> values = Arrays.asList(property.getArchetypeRange());
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("act.customerAccountChargesInvoice"));
        Assert.assertTrue((boolean)values.contains("act.customerAccountChargesCredit"));
        Assert.assertTrue((boolean)values.contains("act.customerAccountChargesCounter"));
    }

    @Override
    @Test
    public void testIsDerived() {
        org.openvpms.component.model.archetype.NodeDescriptor descriptor = this.createDescriptor();
        IMObjectProperty property = new IMObjectProperty(this.createIMObject(), descriptor);
        Assert.assertFalse((boolean)property.isDerived());
        descriptor.setDerived(true);
        Assert.assertTrue((boolean)property.isDerived());
    }

    @Override
    @Test
    public void testIsReadOnly() {
        org.openvpms.component.model.archetype.NodeDescriptor descriptor = this.createDescriptor();
        IMObjectProperty property = new IMObjectProperty(this.createIMObject(), descriptor);
        Assert.assertFalse((boolean)property.isReadOnly());
        descriptor.setReadOnly(true);
        Assert.assertTrue((boolean)property.isReadOnly());
    }

    @Override
    @Test
    public void testIsHidden() {
        org.openvpms.component.model.archetype.NodeDescriptor descriptor = this.createDescriptor();
        IMObjectProperty property = new IMObjectProperty(this.createIMObject(), descriptor);
        Assert.assertFalse((boolean)property.isHidden());
        descriptor.setHidden(true);
        Assert.assertTrue((boolean)property.isHidden());
    }

    @Override
    @Test
    public void testIsRequired() {
        org.openvpms.component.model.archetype.NodeDescriptor descriptor = this.createDescriptor();
        IMObjectProperty property = new IMObjectProperty(this.createIMObject(), descriptor);
        Assert.assertFalse((boolean)property.isRequired());
        descriptor.setMinCardinality(1);
        Assert.assertTrue((boolean)property.isRequired());
    }

    @Test
    public void testGetMinCardinality() {
        org.openvpms.component.model.archetype.NodeDescriptor descriptor = this.createDescriptor();
        IMObjectProperty property = new IMObjectProperty(this.createIMObject(), descriptor);
        Assert.assertEquals((long)0L, (long)property.getMinCardinality());
        descriptor.setMinCardinality(1);
        Assert.assertEquals((long)1L, (long)property.getMinCardinality());
    }

    @Test
    public void testGetMaxCardinality() {
        org.openvpms.component.model.archetype.NodeDescriptor descriptor = this.createDescriptor();
        IMObjectProperty property = new IMObjectProperty(this.createIMObject(), descriptor);
        Assert.assertEquals((long)1L, (long)property.getMaxCardinality());
        descriptor.setMaxCardinality(10);
        Assert.assertEquals((long)10L, (long)property.getMaxCardinality());
        descriptor.setMaxCardinality(-1);
        Assert.assertEquals((long)-1L, (long)property.getMaxCardinality());
    }

    @Test
    public void testUnsupportedOperationExceptionForDerivedProperty() {
        org.openvpms.component.model.archetype.NodeDescriptor descriptor = this.createDescriptor();
        descriptor.setName("derived");
        descriptor.setDerived(true);
        IMObjectProperty property = new IMObjectProperty(this.createIMObject(), descriptor);
        try {
            property.setValue((Object)"Foo");
            Assert.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            property.add((Object)"Foo");
            Assert.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            property.remove((Object)"Foo");
            Assert.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testRequiredValidation() {
        Party person = (Party)this.create("party.customerperson", Party.class);
        NodeDescriptor descriptor = PropertyTestHelper.getDescriptor((org.openvpms.component.model.object.IMObject)person, "lastName");
        IMObjectProperty property = new IMObjectProperty((org.openvpms.component.model.object.IMObject)person, (org.openvpms.component.model.archetype.NodeDescriptor)descriptor);
        property.setValue(null);
        String error = Messages.format((String)"property.error.required", (Object[])new Object[]{property.getDisplayName()});
        this.checkValidationError((Property)property, error);
        property.setValue((Object)"X");
        Assert.assertTrue((boolean)property.isValid());
        property.setValue((Object)"");
        this.checkValidationError((Property)property, error);
    }

    @Test
    public void testMinCardinalityValidation() {
        Party customer = TestHelper.createCustomer((boolean)false);
        Act invoice = (Act)this.create("act.customerAccountChargesInvoice", Act.class);
        Participation participation = this.createCustomerParticipation(invoice, customer);
        NodeDescriptor descriptor = PropertyTestHelper.getDescriptor((org.openvpms.component.model.object.IMObject)invoice, "customer");
        Assert.assertEquals((long)1L, (long)descriptor.getMinCardinality());
        IMObjectProperty property = new IMObjectProperty((org.openvpms.component.model.object.IMObject)invoice, (org.openvpms.component.model.archetype.NodeDescriptor)descriptor);
        Assert.assertFalse((boolean)property.isValid());
        String error = Messages.format((String)"property.error.minSize", (Object[])new Object[]{property.getDisplayName(), property.getMinCardinality()});
        this.checkValidationError((Property)property, error);
        property.add((Object)participation);
        Assert.assertTrue((boolean)property.isValid());
        property.remove((Object)participation);
        this.checkValidationError((Property)property, error);
    }

    @Test
    public void testMaxCardinalityValidation() {
        Party customer = TestHelper.createCustomer((boolean)false);
        Act invoice = (Act)this.create("act.customerAccountChargesInvoice", Act.class);
        Participation participation1 = this.createCustomerParticipation(invoice, customer);
        Participation participation2 = this.createCustomerParticipation(invoice, customer);
        NodeDescriptor descriptor = PropertyTestHelper.getDescriptor((org.openvpms.component.model.object.IMObject)invoice, "customer");
        Assert.assertEquals((long)1L, (long)descriptor.getMaxCardinality());
        IMObjectProperty property = new IMObjectProperty((org.openvpms.component.model.object.IMObject)invoice, (org.openvpms.component.model.archetype.NodeDescriptor)descriptor);
        Assert.assertFalse((boolean)property.isValid());
        String error = Messages.format((String)"property.error.maxSize", (Object[])new Object[]{property.getDisplayName(), property.getMinCardinality()});
        property.add((Object)participation1);
        property.add((Object)participation2);
        this.checkValidationError((Property)property, error);
        property.remove((Object)participation1);
        Assert.assertTrue((boolean)property.isValid());
    }

    @Test
    public void testValidationOfInvalidCollectionItems() {
        Party customer = TestHelper.createCustomer((boolean)false);
        Act invoice = (Act)this.create("act.customerAccountChargesInvoice", Act.class);
        Participation participation = this.createCustomerParticipation(invoice, customer);
        NodeDescriptor descriptor = PropertyTestHelper.getDescriptor((org.openvpms.component.model.object.IMObject)invoice, "customer");
        IMObjectProperty property = new IMObjectProperty((org.openvpms.component.model.object.IMObject)invoice, (org.openvpms.component.model.archetype.NodeDescriptor)descriptor);
        participation.setAct(null);
        property.add((Object)participation);
        String error = "Failed to validate Act of Act Customer: value is required";
        this.checkPreformattedValidationError((Property)property, error);
        participation.setAct(invoice.getObjectReference());
        Assert.assertTrue((boolean)property.isValid());
    }

    @Test
    public void testValidateAssertions() {
        IMObjectProperty property = this.createProperty("name", String.class);
        org.openvpms.component.model.archetype.NodeDescriptor descriptor = property.getDescriptor();
        descriptor.setPath("/name");
        org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor assertion = new org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor();
        assertion.setDescriptor((AssertionTypeDescriptor)this.getArchetypeService().getAssertionTypeDescriptor("regularExpression"));
        Assert.assertNotNull((Object)assertion.getDescriptor());
        assertion.setName("regularExpression");
        AssertionProperty ap = new AssertionProperty();
        ap.setName("expression");
        ap.setValue("\\d+");
        assertion.addProperty((NamedProperty)ap);
        descriptor.addAssertionDescriptor((AssertionDescriptor)assertion);
        property.setValue((Object)"abc");
        Assert.assertFalse((boolean)property.validate((Validator)new DefaultValidator()));
        property.setValue((Object)"123");
        Assert.assertTrue((boolean)property.validate((Validator)new DefaultValidator()));
    }

    public void testIsEmptyCollection() {
        Party customer = (Party)this.create("party.customerperson", Party.class);
        NodeDescriptor descriptor = PropertyTestHelper.getDescriptor((org.openvpms.component.model.object.IMObject)customer, "contacts");
        IMObjectProperty property = new IMObjectProperty((org.openvpms.component.model.object.IMObject)customer, (org.openvpms.component.model.archetype.NodeDescriptor)descriptor);
        Assert.assertTrue((boolean)property.isEmpty());
        property.add((Object)TestHelper.createPhoneContact((String)"03", (String)"1234567"));
        Assert.assertFalse((boolean)property.isEmpty());
    }

    @Override
    protected Property createBooleanProperty(String name) {
        return this.createProperty(name, "active", (org.openvpms.component.model.object.IMObject)TestHelper.createCustomer((boolean)false));
    }

    @Override
    protected Property createStringProperty(String name, int minLength, int maxLength) {
        IMObjectProperty result = this.createProperty(name, "lastName", (org.openvpms.component.model.object.IMObject)TestHelper.createCustomer((boolean)false));
        result.getDescriptor().setMinLength(minLength);
        result.getDescriptor().setMaxLength(maxLength);
        return result;
    }

    protected IMObjectProperty createProperty(String name, Class type) {
        org.openvpms.component.model.object.IMObject object = this.createIMObject();
        ((IMObject)object).setArchetypeId(new ArchetypeId("party.customerperson"));
        org.openvpms.component.model.archetype.NodeDescriptor descriptor = this.createDescriptor();
        descriptor.setName(name);
        descriptor.setType(type.getName());
        return new IMObjectProperty(object, descriptor);
    }

    @Override
    protected AbstractPropertyTest.TestProperty createTestProperty(int minLength, int maxLength) {
        Party customer = TestHelper.createCustomer((boolean)false);
        org.openvpms.component.model.archetype.NodeDescriptor descriptor = this.cloneDescriptor("foo", "lastName", (org.openvpms.component.model.object.IMObject)customer);
        descriptor.setMinLength(minLength);
        descriptor.setMaxLength(maxLength);
        return new IMObjectTestProperty((org.openvpms.component.model.object.IMObject)customer, descriptor);
    }

    @Override
    protected void checkValidationError(Property property, String message) {
        IMObjectProperty p = (IMObjectProperty)property;
        org.openvpms.component.model.object.IMObject parent = p.getObject();
        String expected = ValidatorError.format((String)parent.getArchetype(), (String)property.getName(), (String)message);
        super.checkValidationError(property, expected);
    }

    private org.openvpms.component.model.object.IMObject createIMObject() {
        return new IMObject();
    }

    private org.openvpms.component.model.archetype.NodeDescriptor createDescriptor() {
        return new NodeDescriptor();
    }

    private IMObjectProperty createProperty(String name, String nodeName, org.openvpms.component.model.object.IMObject object) {
        org.openvpms.component.model.archetype.NodeDescriptor descriptor = this.cloneDescriptor(name, nodeName, object);
        return new IMObjectProperty(object, descriptor);
    }

    private org.openvpms.component.model.archetype.NodeDescriptor cloneDescriptor(String name, String nodeName, org.openvpms.component.model.object.IMObject object) {
        NodeDescriptor descriptor = PropertyTestHelper.getDescriptor(object, nodeName);
        try {
            NodeDescriptor d = descriptor;
            descriptor = (org.openvpms.component.model.archetype.NodeDescriptor)d.clone();
        }
        catch (CloneNotSupportedException exception) {
            Assert.fail((String)"Failed to clone descriptor");
        }
        descriptor.setName(name);
        return descriptor;
    }

    private void checkPreformattedValidationError(Property property, String message) {
        super.checkValidationError(property, message);
    }

    private Participation createCustomerParticipation(Act act, Party customer) {
        Participation participation = (Participation)this.create("participation.customer", Participation.class);
        participation.setAct(act.getObjectReference());
        participation.setEntity(customer.getObjectReference());
        return participation;
    }

    private void addArchetypeRange(org.openvpms.component.model.archetype.NodeDescriptor descriptor, String value) {
        org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor range = new org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor();
        range.setName("archetypeRange");
        PropertyList archetypes = new PropertyList();
        archetypes.setName("archetypes");
        PropertyMap archetype = new PropertyMap();
        archetype.setName("archetype");
        AssertionProperty shortName = new AssertionProperty();
        shortName.setName("shortName");
        shortName.setValue(value);
        archetype.addProperty((NamedProperty)shortName);
        archetypes.addProperty((NamedProperty)archetype);
        range.addProperty((NamedProperty)archetypes);
        descriptor.addAssertionDescriptor((AssertionDescriptor)range);
    }

    private static class IMObjectTestProperty
    extends IMObjectProperty
    implements AbstractPropertyTest.TestProperty {
        private int count = 0;

        IMObjectTestProperty(org.openvpms.component.model.object.IMObject object, org.openvpms.component.model.archetype.NodeDescriptor descriptor) {
            super(object, descriptor);
        }

        @Override
        public int getValidations() {
            return this.count;
        }

        protected boolean doValidation(Validator validator) {
            ++this.count;
            return super.doValidation(validator);
        }
    }
}

