/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.web.component.mail.HtmlFilter;

public class HtmlFilterTestCase {
    @Test
    public void testHtml() {
        String html = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html>\n<head>\n  <title></title>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n  <style type=\"text/css\">\n    a {text-decoration: none}\n  </style>\n</head>\n<body>Hello World!</body></html>";
        String result = HtmlFilter.filter((String)html);
        Assert.assertEquals((Object)"Hello World!", (Object)result);
    }

    @Test
    public void testAttributes() {
        String html = "<IMG SRC=\"http://www.creaturecomforts.com.hk/images/hh1.jpg\" NAME=\"graphics1\" ALIGN=LEFT WIDTH=384 HEIGHT=224 BORDER=0><BR CLEAR=LEFT><BR>";
        String result = HtmlFilter.filter((String)html);
        String expected = "<img src=\"http://www.creaturecomforts.com.hk/images/hh1.jpg\" name=\"graphics1\" align=\"left\" width=\"384\" height=\"224\" border=\"0\"/><br clear=\"left\"/><br/>";
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testElements() {
        String html = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n<html>\n  <head>\n    <title>Sample</title>\n  </head>\n\n  <body>\n    <p>This should be normal</p>\n    <p><span style=\"font-size: 19pt; color: #CC0000\">This should be in big red letters.</span></p>\n  </body>\n</html>\n";
        String result = HtmlFilter.filter((String)html);
        String expected = "<p>This should be normal</p><p><span style=\"font-size: 19pt; color: #CC0000\">This should be in big red letters.</span></p>";
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testEscaping() {
        String html = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n<html>\n  <head>\n    <title>Sample</title>\n  </head>\n\n  <body>\n  <p>&lt;&gt;</p>  </body>\n</html>\n";
        String result = HtmlFilter.filter((String)html);
        String expected = "<p>&lt;&gt;</p>";
        Assert.assertEquals((Object)expected, (Object)result);
    }
}

