/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.till;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.finance.till.TillRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.tilldrawer.internal.service.DefaultTillDrawerService;
import org.openvpms.tilldrawer.service.TillDrawerService;
import org.openvpms.web.component.im.till.CashDrawer;
import org.openvpms.web.component.im.till.CashDrawerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CashDrawerTestCase
extends ArchetypeServiceTest {
    @Autowired
    private DomainService domainService;
    @Autowired
    private TillRules rules;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    private Party customer;
    private CashDrawerFactory factory;

    @Before
    public void setUp() {
        this.customer = this.customerFactory.createCustomer();
        DefaultTillDrawerService tillDrawerService = new DefaultTillDrawerService();
        this.factory = new CashDrawerFactory((TillDrawerService)tillDrawerService, this.rules, (ArchetypeService)this.getArchetypeService(), this.domainService);
    }

    @Test
    public void testCanOpen() {
        Entity till1 = this.createTill(null, null);
        CashDrawer drawer1 = this.factory.create(till1);
        Assert.assertFalse((boolean)drawer1.canOpen());
        Entity till2 = this.createTill("foo", "27,112,0,50,250");
        CashDrawer drawer2 = this.factory.create(till2);
        Assert.assertTrue((boolean)drawer2.canOpen());
    }

    @Test
    public void testNeedsOpen() {
        Entity till = this.createTill("foo", "27,112,0,50,250");
        CashDrawer drawer = this.factory.create(till);
        FinancialAct payment1 = this.createPayment(till, "act.customerAccountPaymentCash", "IN_PROGRESS");
        Assert.assertFalse((boolean)drawer.needsOpen((Act)payment1));
        payment1.setStatus("POSTED");
        Assert.assertTrue((boolean)drawer.needsOpen((Act)payment1));
        FinancialAct payment2 = this.createPayment(till, "act.customerAccountPaymentCheque", "POSTED");
        Assert.assertTrue((boolean)drawer.needsOpen((Act)payment2));
        FinancialAct payment3 = this.createPaymentEFT(till, "POSTED", BigDecimal.ZERO);
        Assert.assertFalse((boolean)drawer.needsOpen((Act)payment3));
        FinancialAct payment4 = this.createPaymentEFT(till, "POSTED", BigDecimal.TEN);
        Assert.assertTrue((boolean)drawer.needsOpen((Act)payment4));
        FinancialAct payment5 = this.createPayment(till, "act.customerAccountPaymentCredit", "POSTED");
        Assert.assertTrue((boolean)drawer.needsOpen((Act)payment5));
        FinancialAct payment6 = this.createPayment(till, "act.customerAccountPaymentDiscount", "POSTED");
        Assert.assertFalse((boolean)drawer.needsOpen((Act)payment6));
        FinancialAct payment7 = this.createPayment(till, "act.customerAccountPaymentOther", "POSTED");
        Assert.assertFalse((boolean)drawer.needsOpen((Act)payment7));
        FinancialAct refund1 = this.createRefund(till, "act.customerAccountRefundCash", "IN_PROGRESS");
        Assert.assertFalse((boolean)drawer.needsOpen((Act)refund1));
        refund1.setStatus("POSTED");
        Assert.assertTrue((boolean)drawer.needsOpen((Act)refund1));
        FinancialAct refund2 = this.createRefund(till, "act.customerAccountRefundCheque", "POSTED");
        Assert.assertTrue((boolean)drawer.needsOpen((Act)refund2));
        FinancialAct refund3 = this.createRefund(till, "act.customerAccountRefundEFT", "POSTED");
        Assert.assertFalse((boolean)drawer.needsOpen((Act)refund3));
        FinancialAct refund5 = this.createRefund(till, "act.customerAccountRefundCredit", "POSTED");
        Assert.assertTrue((boolean)drawer.needsOpen((Act)refund5));
        FinancialAct refund6 = this.createRefund(till, "act.customerAccountRefundDiscount", "POSTED");
        Assert.assertFalse((boolean)drawer.needsOpen((Act)refund6));
        FinancialAct refund7 = this.createRefund(till, "act.customerAccountRefundOther", "POSTED");
        Assert.assertFalse((boolean)drawer.needsOpen((Act)refund7));
    }

    private Entity createTill(String printerName, String command) {
        return (Entity)this.practiceFactory.newTill().printer(printerName).drawerCommand(command).build();
    }

    private FinancialAct createPayment(Entity till, String itemShortName, String status) {
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.ONE, (Party)this.customer, (Entity)till, (String)status);
        FinancialAct item = FinancialTestHelper.createPaymentRefundItem((String)itemShortName, (BigDecimal)BigDecimal.ONE);
        return this.addItem(payment, item);
    }

    private FinancialAct createPaymentEFT(Entity till, String status, BigDecimal cashout) {
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)till, (String)status);
        FinancialAct item = FinancialTestHelper.createPaymentRefundItem((String)"act.customerAccountPaymentEFT", (BigDecimal)BigDecimal.ONE);
        IMObjectBean bean = this.getBean((IMObject)item);
        bean.setValue("cashout", (Object)cashout);
        return this.addItem(payment, item);
    }

    private FinancialAct createRefund(Entity till, String itemShortName, String status) {
        FinancialAct refund = FinancialTestHelper.createRefund((BigDecimal)BigDecimal.ONE, (Party)this.customer, (Entity)till, (String)status);
        FinancialAct item = FinancialTestHelper.createPaymentRefundItem((String)itemShortName, (BigDecimal)BigDecimal.ONE);
        return this.addItem(refund, item);
    }

    private FinancialAct addItem(FinancialAct act, FinancialAct item) {
        IMObjectBean bean = this.getBean((IMObject)act);
        ActRelationship relationship = (ActRelationship)bean.addTarget("items", (IMObject)item);
        item.addActRelationship(relationship);
        this.save((IMObject[])new FinancialAct[]{act, item});
        return act;
    }
}

