/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.sms;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.lookup.TestMacroBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.sms.internal.service.SMSLengthCalculator;
import org.openvpms.sms.service.SMSService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.sms.SMSEditor;
import org.openvpms.web.component.macro.MacroVariables;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;

public class SMSEditorTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    private SMSService smsService;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.smsService = (SMSService)Mockito.mock(SMSService.class);
        Mockito.when((Object)this.smsService.getMaxParts()).thenReturn((Object)1);
        Mockito.when((Object)this.smsService.getParts(ArgumentMatchers.anyString())).then(invocation -> SMSLengthCalculator.getParts((String)((String)invocation.getArgument(0))));
    }

    @Test
    public void testMacroExpansion() {
        Party location = (Party)((TestLocationBuilder)((TestLocationBuilder)this.practiceFactory.newLocation().name("Pets R Us")).addPhone("912345678", new String[0])).build();
        Party customer = this.customerFactory.createCustomer();
        Party patient = (Party)((TestPatientBuilder)this.patientFactory.newPatient().name("Fido")).owner(customer).build();
        Entity schedule = this.schedulingFactory.createSchedule(location);
        Entity appointmentType = this.schedulingFactory.createAppointmentType();
        Act appointment = (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime("2019-02-22 09:00:00")).schedule(schedule).appointmentType(appointmentType).customer(customer)).patient(patient)).build();
        LocalContext context = new LocalContext();
        context.setLocation(location);
        context.setAppointment(appointment);
        String expression = "concat(expr:if(boolean($appointment.patient), concat($appointment.patient.entity.name, \"'s\"), 'Your'), ' appointment at ', $appointment.schedule.entity.location.target.name, ' is confirmed for ', date:format($appointment.startTime, 'dd/MM/yy'), ' @ ', date:format($appointment.startTime, 'hh:mm'), $nl, 'Call us on ', party:getTelephone($location), ' if you need to change the appointment')";
        ((TestMacroBuilder)this.lookupFactory.newMacro().code("@testconfappointment")).expression(expression).build();
        MacroVariables variables = new MacroVariables((Context)context, (ArchetypeService)this.getArchetypeService(), this.getLookupService());
        SMSEditor editor = new SMSEditor(Collections.emptyList(), (Variables)variables, (Context)context, this.smsService);
        editor.setMessage("@testconfappointment");
        Assert.assertEquals((Object)"Fido's appointment at Pets R Us is confirmed for 22/02/19 @ 09:00\nCall us on 912345678 if you need to change the appointment", (Object)editor.getMessage());
        IMObjectBean appointmentBean = this.getBean((IMObject)appointment);
        appointmentBean.removeValues("patient");
        editor.setMessage("@testconfappointment");
        Assert.assertEquals((Object)"Your appointment at Pets R Us is confirmed for 22/02/19 @ 09:00\nCall us on 912345678 if you need to change the appointment", (Object)editor.getMessage());
    }

    @Test
    public void testInvalidPhone() {
        Party customer1 = (Party)this.customerFactory.newCustomer().build();
        Party customer2 = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addPhone("", new String[0])).build();
        Party customer3 = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addPhone("      ", new String[0])).build();
        Party customer4 = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addPhone("need to get an updated number", new String[0])).build();
        this.checkInvalid(customer1, "a message", "Phone is required");
        this.checkInvalid(customer2, "a message", "Phone is required");
        this.checkInvalid(customer3, "a message", "Phone is required");
        this.checkInvalid(customer4, "a message", "Phone is required");
    }

    @Test
    public void testInvalidMessage() {
        Party customer = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addPhone("123456789", new String[0])).build();
        this.checkInvalid(customer, null, "Message is required");
        this.checkInvalid(customer, "", "Message is required");
        this.checkInvalid(customer, "   ", "Message is required");
        this.checkInvalid(customer, StringUtils.repeat((String)"x", (int)161), "SMS is too long: 2 parts were entered but only 1 is supported");
    }

    private void checkInvalid(Party party, String message, String expected) {
        ArrayList contacts = new ArrayList(party.getContacts());
        LocalContext context = new LocalContext();
        MacroVariables variables = new MacroVariables((Context)context, (ArchetypeService)this.getArchetypeService(), this.getLookupService());
        SMSEditor editor = new SMSEditor(contacts, (Variables)variables, (Context)context, this.smsService);
        editor.setMessage(message);
        EditorTestHelper.assertInvalid((Modifiable)editor, expected);
    }
}

