/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.component.business.service.archetype.helper.IMObjects;
import org.openvpms.component.model.archetype.ArchetypeRange;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.AbstractCollectionPropertyEditorTest;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.relationship.EntityRelationshipCollectionTargetPropertyEditor;
import org.openvpms.web.component.property.CollectionProperty;
import org.springframework.beans.factory.annotation.Autowired;

public class EntityRelationshipCollectionTargetPropertyEditorTestCase
extends AbstractCollectionPropertyEditorTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;

    @Test
    public void testGetArchetypeRange() {
        IMObject parent = this.createParent();
        CollectionProperty property = this.getCollectionProperty(parent);
        CollectionPropertyEditor editor = this.createEditor(property, parent, this.getObjects());
        String[] archetypes = editor.getArchetypeRange();
        Assert.assertEquals((long)1L, (long)archetypes.length);
        Assert.assertEquals((Object)"party.patientpet", (Object)archetypes[0]);
    }

    @Test
    public void testGetArchetypes() {
        IMObject parent = this.createParent();
        CollectionProperty property = this.getCollectionProperty(parent);
        CollectionPropertyEditor editor = this.createEditor(property, parent, this.getObjects());
        ArchetypeRange range = editor.getArchetypes();
        List archetypes = range.getArchetypes();
        Assert.assertEquals((long)1L, (long)archetypes.size());
        Assert.assertEquals((Object)"party.patientpet", archetypes.get(0));
        Assert.assertNull((Object)range.getDefaultArchetype());
    }

    @Override
    protected IMObject createParent() {
        return this.customerFactory.createCustomer();
    }

    @Override
    protected String getCollectionNode() {
        return "patients";
    }

    @Override
    protected CollectionPropertyEditor createEditor(CollectionProperty property, IMObject parent, IMObjects objects) {
        return new EntityRelationshipCollectionTargetPropertyEditor(property, (Entity)parent, objects);
    }

    @Override
    protected IMObject createObject(IMObject parent) {
        return this.patientFactory.createPatient();
    }

    @Override
    protected void makeValid(IMObject object, boolean valid) {
        IMObjectBean bean = this.getBean(object);
        bean.setValue("species", (Object)(valid ? "CANINE" : null));
    }

    @Override
    protected void modify(IMObject object) {
        IMObjectBean bean = this.getBean(object);
        String current = bean.getString("species");
        if ("CANINE".equals(current)) {
            bean.setValue("species", (Object)"FELINE");
        } else {
            bean.setValue("species", (Object)"CANINE");
        }
    }
}

