/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjects;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.edit.AbstractCollectionPropertyEditorTest;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.relationship.EntityRelationshipCollectionPropertyEditor;
import org.openvpms.web.component.im.relationship.RelationshipState;
import org.openvpms.web.component.property.CollectionProperty;

public class EntityRelationshipCollectionPropertyEditorTestCase
extends AbstractCollectionPropertyEditorTest {
    @Test
    public void testRelationshipState() {
        Party customer = this.createParent();
        CollectionProperty property = this.getCollectionProperty((IMObject)customer);
        EntityRelationshipCollectionPropertyEditor editor = new EntityRelationshipCollectionPropertyEditor(property, (Entity)customer);
        Assert.assertEquals((long)0L, (long)editor.getRelationships().size());
        Party patient1 = TestHelper.createPatient((String)"Fido", (boolean)true);
        Party patient2 = TestHelper.createPatient((String)"Spot", (boolean)true);
        EntityRelationship relationship1 = this.createOwnerRelationship((IMObject)customer, (IMObject)patient1);
        Assert.assertTrue((boolean)editor.add((IMObject)relationship1));
        this.checkRelationships(editor, relationship1);
        this.checkState(editor, relationship1, "Fido");
        EntityRelationship relationship2 = this.createOwnerRelationship((IMObject)customer, (IMObject)patient2);
        Assert.assertTrue((boolean)editor.add((IMObject)relationship2));
        this.checkRelationships(editor, relationship1, relationship2);
        this.checkState(editor, relationship2, "Spot");
        editor.remove((IMObject)relationship2);
        this.checkRelationships(editor, relationship1);
        relationship1.setTarget(patient2.getObjectReference());
        Assert.assertFalse((boolean)editor.add((IMObject)relationship1));
        this.checkRelationships(editor, relationship1);
        this.checkState(editor, relationship1, "Spot");
    }

    protected Party createParent() {
        return TestHelper.createCustomer((boolean)true);
    }

    @Override
    protected String getCollectionNode() {
        return "patients";
    }

    @Override
    protected CollectionPropertyEditor createEditor(CollectionProperty property, IMObject parent, IMObjects objects) {
        return new EntityRelationshipCollectionPropertyEditor(property, (Entity)parent);
    }

    @Override
    protected IMObject createObject(IMObject parent) {
        return this.createOwnerRelationship(parent, (IMObject)TestHelper.createPatient((boolean)true));
    }

    @Override
    protected void makeValid(IMObject object, boolean valid) {
        IMObjectBean bean = this.getBean(object);
        bean.setValue("activeStartTime", (Object)(valid ? new Date() : null));
    }

    @Override
    protected void modify(IMObject object) {
        IMObjectBean bean = this.getBean(object);
        Date date = bean.getDate("activeStartTime", new Date());
        bean.setValue("activeStartTime", (Object)DateRules.getDate((Date)date, (int)1, (DateUnits)DateUnits.DAYS));
    }

    private void checkRelationships(EntityRelationshipCollectionPropertyEditor editor, EntityRelationship ... relationships) {
        List objects = editor.getObjects();
        Assert.assertEquals((long)relationships.length, (long)objects.size());
        Collection states = editor.getRelationships();
        Assert.assertEquals((long)relationships.length, (long)states.size());
        for (EntityRelationship relationship : relationships) {
            Assert.assertTrue((boolean)objects.contains(relationship));
            boolean found = false;
            for (RelationshipState state : states) {
                if (!state.getRelationship().equals(relationship)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
        }
    }

    private void checkState(EntityRelationshipCollectionPropertyEditor editor, EntityRelationship relationship, String name) {
        RelationshipState state = editor.getRelationshipState((Relationship)relationship);
        Assert.assertEquals((Object)state.getSource(), (Object)relationship.getSource());
        Assert.assertEquals((long)state.getSourceId(), (long)relationship.getSource().getId());
        Assert.assertEquals((Object)state.getTarget(), (Object)relationship.getTarget());
        Assert.assertEquals((long)state.getTargetId(), (long)relationship.getTarget().getId());
        Assert.assertNotNull((Object)state);
        Assert.assertEquals((Object)name, (Object)state.getTargetName());
    }

    private EntityRelationship createOwnerRelationship(IMObject customer, IMObject patient) {
        EntityRelationship result = (EntityRelationship)this.create("entityRelationship.patientOwner", EntityRelationship.class);
        result.setSource(customer.getObjectReference());
        result.setTarget(patient.getObjectReference());
        return result;
    }
}

