/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;

public class ResultSetIteratorTestCase {
    @Test
    public void testEmpty() {
        ListResultSet<Integer> set = this.createResultSet(0, 10);
        ResultSetIterator iterator = new ResultSetIterator(set);
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"Expected NoSuchElementException to be thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testForwardIteration() {
        ListResultSet<Integer> resultSet = this.createResultSet(50, 20);
        ResultSetIterator iterator = new ResultSetIterator(resultSet);
        int count = 0;
        while (iterator.hasNext()) {
            int next = (Integer)iterator.next();
            Assert.assertEquals((long)count, (long)next);
            Assert.assertEquals((long)count, (long)iterator.lastIndex());
            Assert.assertEquals((long)(count + 1), (long)iterator.nextIndex());
            ++count;
        }
        Assert.assertEquals((long)resultSet.getResults(), (long)iterator.nextIndex());
        Assert.assertEquals((long)resultSet.getResults(), (long)count);
    }

    @Test
    public void testReverseIteration() {
        int size = 50;
        int pageSize = 20;
        ListResultSet<Integer> resultSet = this.createResultSet(size, pageSize);
        ResultSetIterator iterator = new ResultSetIterator(resultSet);
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        Assert.assertEquals((long)size, (long)count);
        Assert.assertEquals((long)size, (long)iterator.nextIndex());
        while (iterator.hasPrevious()) {
            Assert.assertEquals((long)(--count), (long)iterator.previousIndex());
            int previous = (Integer)iterator.previous();
            Assert.assertEquals((long)count, (long)previous);
        }
    }

    private ListResultSet<Integer> createResultSet(int size, int pageSize) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            result.add(i);
        }
        return new ListResultSet(result, pageSize);
    }
}

