/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.FilteredResultSet;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;

public class FilteredResultSetTestCase {
    @Test
    public void testEmpty() {
        FilteredResultSet<Integer> set = this.createOddFilteredResultSet(new ArrayList<Integer>(), 20);
        Assert.assertFalse((boolean)set.hasNext());
        Assert.assertFalse((boolean)set.hasPrevious());
        Assert.assertEquals((long)0L, (long)set.getPages());
        Assert.assertEquals((long)0L, (long)set.getResults());
        Assert.assertNull((Object)set.getPage(0));
        Assert.assertNull((Object)set.getPage(1));
        Assert.assertEquals((long)20L, (long)set.getPageSize());
        Assert.assertTrue((boolean)set.isSortedAscending());
        Assert.assertTrue((set.getSortConstraints() != null && set.getSortConstraints().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFilter() {
        ArrayList<Integer> objects = new ArrayList<Integer>();
        for (int i = 0; i < 25; ++i) {
            objects.add(i);
        }
        FilteredResultSet<Integer> set = this.createOddFilteredResultSet(objects, 5);
        Assert.assertEquals((long)0L, (long)set.getEstimatedResults());
        Assert.assertTrue((boolean)set.hasNext());
        Assert.assertEquals((long)5L, (long)set.getEstimatedResults());
        Assert.assertFalse((boolean)set.isEstimatedActual());
        this.checkPage((IPage<Integer>)set.next(), 5, 0, 0, 2, 4, 6, 8);
        Assert.assertTrue((boolean)set.hasNext());
        Assert.assertTrue((boolean)set.hasPrevious());
        Assert.assertEquals((long)10L, (long)set.getEstimatedResults());
        Assert.assertFalse((boolean)set.isEstimatedActual());
        this.checkPage((IPage<Integer>)set.next(), 5, 5, 10, 12, 14, 16, 18);
        Assert.assertTrue((boolean)set.hasNext());
        Assert.assertTrue((boolean)set.hasPrevious());
        Assert.assertEquals((long)13L, (long)set.getEstimatedResults());
        Assert.assertTrue((boolean)set.isEstimatedActual());
        this.checkPage((IPage<Integer>)set.next(), 5, 10, 20, 22, 24);
        Assert.assertFalse((boolean)set.hasNext());
        Assert.assertTrue((boolean)set.hasPrevious());
        Assert.assertEquals((long)13L, (long)set.getEstimatedResults());
        Assert.assertTrue((boolean)set.isEstimatedActual());
        this.checkPage((IPage<Integer>)set.previous(), 5, 10, 20, 22, 24);
        this.checkPage((IPage<Integer>)set.previous(), 5, 5, 10, 12, 14, 16, 18);
        this.checkPage((IPage<Integer>)set.previous(), 5, 0, 0, 2, 4, 6, 8);
        Assert.assertTrue((boolean)set.hasNext());
        Assert.assertFalse((boolean)set.hasPrevious());
        Assert.assertEquals((long)13L, (long)set.getEstimatedResults());
        Assert.assertTrue((boolean)set.isEstimatedActual());
        set.reset();
        int count = 0;
        int expected = 0;
        ResultSetIterator iter = new ResultSetIterator(set);
        while (iter.hasNext()) {
            Assert.assertEquals((long)expected, (long)((Integer)iter.next()).intValue());
            expected += 2;
            ++count;
        }
        Assert.assertEquals((long)13L, (long)count);
    }

    @Test
    public void testInsertingFilter() {
        List<Integer> objects = Arrays.asList(0, 10, 20, 30, 40);
        FilteredResultSet<Integer> set = new FilteredResultSet<Integer>(this.createSet(objects, 3)){

            protected void filter(Integer object, List<Integer> results) {
                if (object == 0) {
                    results.addAll(Arrays.asList(0, 1, 2));
                } else if (object == 20) {
                    results.addAll(Arrays.asList(20, 21, 22, 23, 24, 25, 26));
                } else {
                    results.add(object);
                }
            }
        };
        this.checkPage((IPage<Integer>)set.next(), 3, 0, 0, 1, 2);
        this.checkPage((IPage<Integer>)set.next(), 3, 3, 10, 20, 21);
        this.checkPage((IPage<Integer>)set.next(), 3, 6, 22, 23, 24);
        this.checkPage((IPage<Integer>)set.next(), 3, 9, 25, 26, 30);
        this.checkPage((IPage<Integer>)set.next(), 3, 12, 40);
        Assert.assertFalse((boolean)set.hasNext());
        this.checkPage((IPage<Integer>)set.previous(), 3, 12, 40);
        this.checkPage((IPage<Integer>)set.previous(), 3, 9, 25, 26, 30);
        this.checkPage((IPage<Integer>)set.previous(), 3, 6, 22, 23, 24);
        this.checkPage((IPage<Integer>)set.previous(), 3, 3, 10, 20, 21);
        this.checkPage((IPage<Integer>)set.previous(), 3, 0, 0, 1, 2);
        Assert.assertFalse((boolean)set.hasPrevious());
        set.reset();
        this.checkPage((IPage<Integer>)set.getPage(2), 3, 6, 22, 23, 24);
        this.checkPage((IPage<Integer>)set.getPage(4), 3, 12, 40);
        this.checkPage((IPage<Integer>)set.getPage(0), 3, 0, 0, 1, 2);
    }

    @Test
    public void testSort() {
        ArrayList<Integer> objects = new ArrayList<Integer>();
        for (int i = 0; i < 25; ++i) {
            objects.add(i);
        }
        FilteredResultSet<Integer> set = this.createOddFilteredResultSet(objects, 5);
        this.checkPage((IPage<Integer>)set.next(), 5, 0, 0, 2, 4, 6, 8);
        this.checkPage((IPage<Integer>)set.next(), 5, 5, 10, 12, 14, 16, 18);
        set.sort(new SortConstraint[0]);
        this.checkPage((IPage<Integer>)set.next(), 5, 0, 0, 2, 4, 6, 8);
    }

    @Test
    public void testAllResults() {
        ArrayList<Integer> objects = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            objects.add(i);
        }
        FilteredResultSet<Integer> set = this.createOddFilteredResultSet(objects, -1);
        this.checkPage((IPage<Integer>)set.next(), -1, 0, 0, 2, 4, 6, 8);
        Assert.assertFalse((boolean)set.hasNext());
        Assert.assertTrue((boolean)set.hasPrevious());
    }

    private void checkPage(IPage<Integer> page, int size, int offset, int ... expected) {
        Assert.assertEquals((long)offset, (long)page.getFirstResult());
        Assert.assertEquals((long)size, (long)page.getPageSize());
        List values = page.getResults();
        Assert.assertEquals((long)expected.length, (long)values.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((long)expected[i], (long)((Integer)values.get(i)).intValue());
        }
    }

    protected FilteredResultSet<Integer> createOddFilteredResultSet(List<Integer> objects, int pageSize) {
        ListResultSet<Integer> set = this.createSet(objects, pageSize);
        return new FilteredResultSet<Integer>(set){

            protected void filter(Integer object, List<Integer> results) {
                if (object % 2 == 0) {
                    results.add(object);
                }
            }
        };
    }

    private ListResultSet<Integer> createSet(List<Integer> objects, int pageSize) {
        return new ListResultSet(objects, pageSize);
    }
}

