/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.customer.CustomerObjectSetQuery;
import org.openvpms.web.component.im.customer.CustomerQuery;
import org.openvpms.web.component.im.query.AbstractEntityQueryTest;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;

public class CustomerQueryTestCase
extends AbstractEntityQueryTest<Party> {
    private static final String[] SHORT_NAMES = new String[]{"party.customerperson", "party.organisationOTC"};

    @Test
    public void testQueryByContact() {
        Party customer = (Party)this.createObject(true);
        String address = this.getUniqueValue("ZAddress");
        CustomerQuery query = (CustomerQuery)this.createQuery();
        query.setContact(address);
        ResultSet results = query.query();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)0L, (long)results.getResults());
        this.checkSelects(false, query, customer);
        Contact location = TestHelper.createLocationContact((String)address, (String)"VIC", (String)"MELBOURNE", (String)"3001");
        customer.addContact(location);
        this.save((IMObject)customer);
        results = query.query();
        List list = results.getPage(0).getResults();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)customer, list.get(0));
        this.checkSelects(true, query, customer);
        Assert.assertTrue((results.getPages() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryByPatientName() {
        String patientName = this.getUniqueValue("ZPatient");
        Party customer = (Party)this.createObject(true);
        CustomerQuery query = (CustomerQuery)this.createQuery();
        query.setPatient(patientName);
        ResultSet results = query.query();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)0L, (long)results.getResults());
        this.checkSelects(false, query, customer);
        Party patient = TestHelper.createPatient((Party)customer, (boolean)false);
        patient.setName(patientName);
        this.save((IMObject[])new Party[]{customer, patient});
        List list = results.getPage(0).getResults();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)customer, list.get(0));
        this.checkSelects(true, query, customer);
        Assert.assertTrue((results.getPages() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryByPatientId() {
        Party customer = (Party)this.createObject(true);
        Party patient = TestHelper.createPatient((Party)customer);
        CustomerQuery query = (CustomerQuery)this.createQuery();
        query.setPatient(Long.toString(patient.getId()));
        ResultSet results = query.query();
        Assert.assertNotNull((Object)results);
        List list = results.getPage(0).getResults();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)customer, list.get(0));
        this.checkSelects(true, query, customer);
        Assert.assertTrue((results.getPages() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryByPatientWithMultipleOwnershipRelationships() {
        Party customer1 = (Party)this.createObject(true);
        Party customer2 = (Party)this.createObject(true);
        String patientName = this.getUniqueValue("ZPatient");
        Party patient = TestHelper.createPatient((Party)customer2);
        patient.setName(patientName);
        IMObjectBean bean = this.getBean((IMObject)customer1);
        EntityRelationship relationship = (EntityRelationship)bean.addTarget("patients", "entityRelationship.patientOwner", (IMObject)patient);
        relationship.setActiveStartTime(DateRules.getYesterday());
        relationship.setActiveEndTime(DateRules.getToday());
        this.save((IMObject[])new Party[]{patient, customer1});
        CustomerQuery query = (CustomerQuery)this.createQuery();
        query.getComponent();
        query.setPatient(patientName);
        this.checkSelects(true, query, customer2);
        this.checkSelects(false, query, customer1);
        Assert.assertTrue((query.query().getPages() >= 1 ? 1 : 0) != 0);
        ((CustomerObjectSetQuery)query.getQuery()).setActive(BaseArchetypeConstraint.State.BOTH);
        this.checkSelects(true, query, customer2);
        this.checkSelects(true, query, customer1);
        ((CustomerObjectSetQuery)query.getQuery()).setActive(BaseArchetypeConstraint.State.INACTIVE);
        this.checkSelects(false, query, customer2);
        this.checkSelects(false, query, customer1);
        this.checkSelects(false, query, customer1);
        customer2.setActive(false);
        this.save((IMObject)customer2);
        this.checkSelects(false, query, customer2);
        patient.setActive(false);
        this.save((IMObject)patient);
        this.checkSelects(true, query, customer2);
    }

    @Test
    public void testPatientSortIgnoredWhenNotQueryingByPatient() {
        this.createObject(true);
        CustomerQuery query = (CustomerQuery)this.createQuery();
        query.getComponent();
        query.setPatient(null);
        SortConstraint[] sort = new SortConstraint[]{Constraints.sort((String)"patient.name")};
        ResultSet set1 = query.query(sort);
        Assert.assertNotNull((Object)set1);
        Assert.assertTrue((boolean)set1.hasNext());
        Assert.assertTrue((set1.getPages() >= 1 ? 1 : 0) != 0);
    }

    @Override
    protected Query<Party> createQuery() {
        return new CustomerQuery(SHORT_NAMES);
    }

    @Override
    protected Party createObject(String value, boolean save) {
        return TestHelper.createCustomer((String)"foo", (String)value, (boolean)save);
    }

    @Override
    protected String getUniqueValue() {
        String value = this.getUniqueValue("Z");
        return value.length() <= 30 ? value : value.substring(0, 30);
    }
}

